<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Employee;
use App\Models\Clients;
use App\Models\Farmer;
use App\Models\FarmerMeeting;
use App\Models\FarmActivity;
use App\Models\Revisit;
use App\Models\AgencyVisit;
use App\Models\Agency;
use App\Models\DayStart;
use App\Models\Designation;
use App\Models\Crop;
use App\Models\RevisitPurpose;
use App\Models\AvPurpose;
use App\Models\Product;
use App\Models\material;
use App\Models\leave;
use App\Models\Holiday;
use App\Models\Leavetype;
use App\Models\fieldDay;
use App\Models\Outstanding;
use App\Models\Order;
use App\Models\ToDolist;
use App\Models\ProductType;
use App\Models\ActivityTarget;
use App\Models\Category;
use App\Models\ActivityCount;
use App\Models\CompanyInfo;
use App\Models\Track;
use App\Models\LateLogin;
use Illuminate\Support\Facades\Cache;
use File;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use App\Http\Controllers\CommonController;
use Carbon\Carbon; // Make sure to import the Carbon library

class APIController extends Controller
{
    public function login(Request $request)
    {
        $username = $request->username;
        $password = $request->header('password');
        $userType = $request->userType;
        if ($userType == 'admin') {
            $user = Clients::where('cuname', $username)
                ->where('cpass', $password)
                ->first();
        } else {
            $user = Employee::where('emp_name', $username)
                ->where('password', $password)
                ->first();
        }
        if (!$user) {
            return response()->json([
                'code' => 500,
                'message' => "Invalid credntial",
            ]);
        }
        $authToken = $user->createToken($username)->plainTextToken;

        return response()->json([
            'code' => 200,
            'token' => $authToken,
            'user' => $user->toArray(),
        ]);
    }
    public function login_details($value = '')
    {
        dd(User::find(2));
    }
    public function getCompanyDetails(Request $request)
    {
        $clientData = DB::connection('mysql')
            ->table('tbl_clients')
            ->where('dbname', $request->companyName)
            ->where('status', 'Active')
            ->get();

        return response()->json([
            'code' => 200,
            'clientData' => $clientData,
        ]);
    }
    
    public function getCompanyInfo()
    {
        $companyInfo = CompanyInfo::all();

    return response()->json([
        'code' => 200,
        'Data' => $companyInfo,
    ]);
    }
    
  

public function updateCompanyInfo(Request $request)
{
    // Validate the incoming request data if needed.
    $validatedData = $request->validate([
        'company_name' => 'required|string',
        'address' => 'required|string',
        'number' => 'required|string',
        'email' => 'required|string',
        // 'company_img' => 'sometimes|image|mimes:jpeg,png,jpg,gif|max:2048', // Adjust validation rules as needed.
    ]);

    // Find the company by ID.
    $companyInfo = CompanyInfo::find(1);

    if (!$companyInfo) {
        return response()->json([
            'message' => 'Company not found',
        ], 404);
    }
    // dd($request->hasFile('company_img'));
    // Handle file upload
    if ($request->hasFile('company_img')) {
        // Get the uploaded file and store it in the specified directory.
        $uploadedFile = $request->file('company_img');
        $fileName = time() . '_' . $uploadedFile->getClientOriginalName();
        $path = '/home/imconnect/handheldapi.imconnect.in/images/company_img/';
        $uploadedFile->move($path, $fileName);

        // Update the company information with the new file name.
        $companyInfo->c_img = $fileName;
    }

    // Update other company information.
    $companyInfo->company_name = $validatedData['company_name'];
    $companyInfo->address = $validatedData['address'];
    $companyInfo->number = $validatedData['number'];
    $companyInfo->email = $validatedData['email'];

    // Save the updated record.
    $companyInfo->update();

    return response()->json([
        'message' => 'Company information updated successfully',
        'data' => $companyInfo,
    ], 200);
}

    public function getPurposeList()
    {
        $result = DB::table('tbl_purpose_agencyvisit')
            ->get()
            ->toArray();
        return $result;
    }
    
    public function getAllCropsList()
    {
        $gwtCropData = DB::table('tbl_crop')
            ->get()
            ->toArray();
        $cropData = [];
    
        foreach ($gwtCropData as $value) {
            $cropData[] = [
                'cropId' => $value->cropId,
                'cropName' => $value->cropName
            ];
        }
    
        return $cropData;
    }
    
    public function getAllProductsList()
    {
        $gwtProductData = DB::table('tbl_product')
            ->get()
            ->toArray();
        $productData = [];
    
        foreach ($gwtProductData as $value) {
            $productData[] = [
                'pid' => $value->pid,
                'productName' => $value->productName
            ];
        }
        return $productData;
    }
    
    public function getEmpDetails(Request $request)
    {
        $empID = $request->empID;

        if (!$empID) {
            return response()->json("Employee id required", Response::HTTP_BAD_REQUEST);
        }
        $getEmployeeDetails = Employee::where('id', $empID)
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'employeeDetails' => $getEmployeeDetails,
        ]);
    }
    public function getRegionwiseEmpList(Request $request)
    {
        $regionId = $request->region_id;

        if (!$regionId) {
            return response()->json("Region id required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionwiseEmpList = Employee::whereIn('region', explode(',', $regionId))
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'getRegionwiseEmpList' => $getRegionwiseEmpList,
        ]);
    }
    public function getRegionSdCount(Request $request)
    {
        $regionId = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionId || !$fromDate || !$toDate) {
            return response()->json("Region id, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionSdCount = DB::select("call gavl.getEmpSdCount('$fromDate','$toDate','$regionId')");

        return response()->json([
            'code' => 200,
            'getRegionSdCount' => $getRegionSdCount,
        ]);
    } 
    public function getEmpIcCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpIcCount = Farmer::whereIn('empId', explode(',', $empIds))
            ->whereBetween('farmerRegDate', [$fromDate, $toDate])
            ->count();

        return response()->json([
            'code' => 200,
            'getEmpIcCount' => $getEmpIcCount,
        ]);
    }
    public function getRegionIcCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionIcCount = Farmer::whereIn('farmerRegion', explode(',', $regionIds))
            ->whereBetween('farmerRegDate', [$fromDate, $toDate])
            ->count();

        return response()->json([
            'code' => 200,
            'getRegionIcCount' => $getRegionIcCount,
        ]);
    }
    public function getRegionFMCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionFMCount = FarmerMeeting::whereIn('farmerRegion', explode(',', $regionIds))
            ->whereBetween('fmDate', [$fromDate, $toDate])
            ->count();

        return response()->json([
            'code' => 200,
            'getRegionFMCount' => $getRegionFMCount,
        ]);
    }
    public function getEmpSdCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpSdCount = FarmActivity::where('SD_Flag', 1)
            ->whereIn('empId', explode(',', $empIds))
            ->whereBetween('SD_date', [$fromDate, $toDate])
            ->count();

        return response()->json([
            'code' => 200,
            'getEmpSdCount' => $getEmpSdCount,
        ]);
    }
    public function getEmpSdvCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpSdvCount = DB::select("call gavl.getEmpSdvCount('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpSdvCount' => $getEmpSdvCount,
        ]);
    }
    public function getRegionSdvCount(Request $request)
    {
        $empIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionSdvCount = DB::select("call gavl.getRegionSdvCount('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getRegionSdvCount' => $getRegionSdvCount,
        ]);
    }
    public function getEmpFdCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpFdCount = DB::select("call gavl.getEmpFdCount('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpFdCount' => $getEmpFdCount,
        ]);
    }
    public function getEmpFmCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpFmCount = FarmerMeeting::where('empId', $empIds)
            ->whereBetween('fmDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getEmpFmCount' => $getEmpFmCount,
        ]);
    }
    public function getEmpAvCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpAvCount = AgencyVisit::where('empId', $empIds)
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getEmpAvCount' => $getEmpAvCount,
        ]);
    }
    public function getRegionFdCount(Request $request)
    {
        $farmerRegion = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$farmerRegion || !$fromDate || !$toDate) {
            return response()->json("farmerRegion ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionFdCount = DB::select("call gavl.getRegionFdCount('$fromDate','$toDate','$farmerRegion')");
        return response()->json([
            'code' => 200,
            'getRegionFdCount' => $getRegionFdCount,
        ]);
    }
    public function getEmpRevisitCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date . ' 00:00:00';
        $toDate = $request->to_date . ' 23:59:59';
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpRevisitCount = Revisit::whereIn('empId', explode(',', $empIds))
            ->whereBetween('revisit_datetime', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getEmpRevisitCount' => $getEmpRevisitCount,
        ]);
    }
    public function getRegionRevisitCount(Request $request)
    {
        $farmerRegion = $request->farmerRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$farmerRegion || !$fromDate || !$toDate) {
            return response()->json("Farmer region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionRevisitCount = DB::select("call gavl.getRegionRevisitCount('$fromDate','$toDate','$farmerRegion')");
        return response()->json([
            'code' => 200,
            'getRegionRevisitCount' => $getRegionRevisitCount,
        ]);
    }
    public function getEmpLiquidationCount(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpLiquidationCount = AgencyVisit::where('liquidation', 1)
            ->whereIn('empId', explode(',', $empIds))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getEmpLiquidationCount' => $getEmpLiquidationCount,
        ]);
    }
    public function getRegionLiquidadtionCount(Request $request)
    {
        $agencyRegion = $request->agencyRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$agencyRegion || !$fromDate || !$toDate) {
            return response()->json("agencyRegion ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionLiquidadtionCount = AgencyVisit::where('liquidation', 1)
            ->whereIn('agencyRegion', explode(',', $agencyRegion))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getRegionLiquidadtionCount' => $getRegionLiquidadtionCount,
        ]);
    }
    public function getAgencyList(Request $request)
    {
        $agencyType = $request->agencyType;
        $agencyRegion = $request->agencyRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$agencyType || !$agencyRegion) {
            return response()->json("agencyType and agencyRegion is required", Response::HTTP_BAD_REQUEST);
        }
        $getAgencyList = DB::select("call gavl.getAgencyList('$agencyType','$agencyRegion','$fromDate','$toDate')");
        return response()->json([
            'code' => 200,
            'getAgencyList' => $getAgencyList,
        ]);
    }
    public function getEmpwiseAgencyProfiling(Request $request)
    {
        $agencyType = $request->agencyType;
        $empIds = $request->empID;
        if (!$agencyType || !$empIds) {
            return response()->json("agencyType and empID is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpwiseAgencyProfiling = DB::select("call gavl.getEmpwiseAgencyProfiling('$agencyType','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpwiseAgencyProfiling' => $getEmpwiseAgencyProfiling,
        ]);
    }
    public function getRegionwiseAgencyProfiling(Request $request)
    {
        $empIds = $request->empIds;
        if (!$empIds) {
            return response()->json("empIds is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionwiseAgencyProfiling = DB::select("call gavl.getRegionwiseAgencyProfiling('$empIds')");
        $getEmpAgencyDetails = [];
        foreach ($getRegionwiseAgencyProfiling as $data) {
            $getCompData1 = DB::table('tbl_company_compitior')
                ->where('cid', $data->agencyFirstCompanyName)
                ->get()
                ->toArray();
            $getCompData2 = DB::table('tbl_company_compitior')
                ->where('cid', $data->agencySecCompanyName)
                ->get()
                ->toArray();
            $getCompData3 = DB::table('tbl_company_compitior')
                ->where('cid', $data->agencyThCompanyName)
                ->get()
                ->toArray();

            $employeeAgencyDetail['empName'] = $data->emp_name;
            $employeeAgencyDetail['empDesignation'] = $data->designationName;
            $employeeAgencyDetail['empRegionName'] = $data->category_name;
            $employeeAgencyDetail['agencyName'] = $data->agencyName;
            $employeeAgencyDetail['agencyShopName'] = $data->agencyShopName;
            $employeeAgencyDetail['agencyMobile'] = $data->agencyMobile;
            $employeeAgencyDetail['agencyAddress'] = $data->agencyAddress;
            $employeeAgencyDetail['agencyTurnover'] = $data->agencyTurnover;
            $employeeAgencyDetail['sealerPgrPer'] = $data->sealerPgrPer;
            $employeeAgencyDetail['sellerPN'] = $data->sellerPN;
            $employeeAgencyDetail['agencyHerbicidePer'] = $data->agencyHerbicidePer;
            $employeeAgencyDetail['agencyInsecticidePer'] = $data->agencyInsecticidePer;
            $employeeAgencyDetail['delaerFungicidePer'] = $data->delaerFungicidePer;
            $employeeAgencyDetail['agencyGAPLTurnover'] = $data->agencyGAPLTurnover;
            $employeeAgencyDetail['sealerGAPLPgrPer'] = $data->sealerGAPLPgrPer;
            $employeeAgencyDetail['GAPLPN'] = $data->GAPLPN;
            $employeeAgencyDetail['agencyGAPLHerbicidePer'] = $data->agencyGAPLHerbicidePer;
            $employeeAgencyDetail['agencyGAPLInsecticidePer'] = $data->agencyGAPLInsecticidePer;
            $employeeAgencyDetail['delaerGAPLFungicidePer'] = $data->delaerGAPLFungicidePer;
            $employeeAgencyDetail['agencyFirstCompanyName'] = count($getCompData1) ? $getCompData1[0]->compititor_name : null;
            $employeeAgencyDetail['agencyFirstCompanyTr'] = $data->agencyFirstCompanyTr;
            $employeeAgencyDetail['agencySecCompanyName'] = count($getCompData2) ? $getCompData2[0]->compititor_name : null;
            $employeeAgencyDetail['agencySecCompanyTr'] = $data->agencySecCompanyTr;
            $employeeAgencyDetail['agencyThCompanyName'] = count($getCompData3) ? $getCompData3[0]->compititor_name : null;
            $employeeAgencyDetail['agencyThCompanyTr'] = $data->agencyThCompanyTr;
            $employeeAgencyDetail['agencyFarmerNetwork'] = $data->agencyFarmerNetwork;
            array_push($getEmpAgencyDetails, $employeeAgencyDetail);
        }
        return response()->json([
            'code' => 200,
            'getRegionwiseAgencyProfiling' => $getEmpAgencyDetails,
        ]);
    }
    public function getRegionList()
    {
        $regionData = DB::table('tbl_category')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'regionList' => $regionData,
        ]);
    }
    public function getcroptype()
    {
        $croptypeData = DB::table('tbl_croptype')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'croptypeList' => $croptypeData,
        ]);
    }
    public function getprodtype()
    {
        $croptypeData = DB::table('tbl_product_type')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'prodtypeList' => $croptypeData,
        ]);
    }
    public function getEmpAttendanceCount(Request $request)
    {
        // code...
    }
    public function getRegionwiseEmpCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("regionIds ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionwiseEmpCount = AgencyVisit::where('liquidation', 1)
            ->whereIn('agencyRegion', explode(',', $agencyRegion))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'getRegionwiseEmpCount' => $getRegionwiseEmpCount,
        ]);
    }
    public function getEmpIcList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpIcList = Farmer::whereIn('empId', explode(',', $empIds))
            ->whereBetween('farmerRegDate', [$fromDate, $toDate])
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'getEmpIcList' => $getEmpIcList,
        ]);
    }
    public function getRegionIcList(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionIcList = Farmer::whereIn('farmerRegion', explode(',', $regionIds))
            ->whereBetween('farmerRegDate', [$fromDate, $toDate])
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'getRegionIcList' => $getRegionIcList,
        ]);
    }
    public function getEmpSdList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpSdList = FarmActivity::where('SD_Flag', 1)
            ->whereIn('empId', explode(',', $empIds))
            ->whereBetween('SD_date', [$fromDate, $toDate])
            ->get()
            ->toArray();
        $getEmpSdList = DB::select("call gavl.getEmpSdList('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpSdList' => $getEmpSdList,
        ]);
    }
    public function getRegionSdList(Request $request)
    {
        $regionId = $request->region_id;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionId || !$fromDate || !$toDate) {
            return response()->json("Region id, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionSdList = DB::select("call gavl.getRegionSdList('$fromDate','$toDate','$regionId')");

        return response()->json([
            'code' => 200,
            'getRegionSdList' => $getRegionSdList,
        ]);
    }
    public function getEmpSdvList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpSdvList = DB::select("call gavl.getEmpSdvList('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpSdvList' => $getEmpSdvList,
        ]);
    }
    public function getRegionSdvList(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionSdvList = DB::select("call gavl.getRegionSdvList('$fromDate','$toDate','$regionIds')");
        return response()->json([
            'code' => 200,
            'getRegionSdvList' => $getRegionSdvList,
        ]);
    }
    public function getEmpFdList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpFdList = DB::select("call gavl.getEmpFdList('$fromDate','$toDate','$empIds')");
        return response()->json([
            'code' => 200,
            'getEmpFdList' => $getEmpFdList,
        ]);
    }
    public function getRegionFdList(Request $request)
    {
        $farmerRegion = $request->farmerRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$farmerRegion || !$fromDate || !$toDate) {
            return response()->json("farmerRegion ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionFdList = DB::select("call gavl.getRegionFdList('$fromDate','$toDate','$farmerRegion')");
        return response()->json([
            'code' => 200,
            'getRegionFdList' => $getRegionFdList,
        ]);
    }
    public function getEmpRevisitList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date . ' 00:00:00';
        $toDate = $request->to_date . ' 23:59:59';
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpRevisitList = Revisit::whereIn('empId', explode(',', $empIds))
            ->whereBetween('revisit_datetime', [$fromDate, $toDate])
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'getEmpRevisitList' => $getEmpRevisitList,
        ]);
    }
    public function getRegionRevisitList(Request $request)
    {
        $farmerRegion = $request->farmerRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$farmerRegion || !$fromDate || !$toDate) {
            return response()->json("Farmer region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionRevisitList = DB::select("call gavl.getRegionRevisitList('$fromDate','$toDate','$farmerRegion')");
        return response()->json([
            'code' => 200,
            'getRegionRevisitList' => $getRegionRevisitList,
        ]);
    }
    public function getEmpLiquidationList(Request $request)
    {
        $empIds = $request->empIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$empIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getEmpLiquidationList = AgencyVisit::where('liquidation', 1)
            ->whereIn('empId', explode(',', $empIds))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'getEmpLiquidationList' => $getEmpLiquidationList,
        ]);
    }
    public function getRegionLiquidadtionList(Request $request)
    {
        $agencyRegion = $request->agencyRegion;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$agencyRegion || !$fromDate || !$toDate) {
            return response()->json("agencyRegion ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRegionLiquidadtionList = AgencyVisit::where('liquidation', 1)
            ->whereIn('agencyRegion', explode(',', $agencyRegion))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'getRegionLiquidadtionList' => $getRegionLiquidadtionList,
        ]);
    }
    // public function getRegion(Request $request)
    // {

    //     $getAllRegion = DB::select($sql)
    //         ->get()
    //         ->toArray();
    //     return response()->json([
    //         'code' => 200,
    //         'getAllRegion' => $getAllRegion,
    //     ]);
    // }
    public function getRegion(Request $request)
    {
        if (isset($request->loginRegion) && $request->loginRegion) {
            $regionIndex = $request->loginRegion;
            $categoryIDWithParent = $regionIndex . ',' . $this->getRegionId($regionIndex);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $getAllRegion = DB::table('tbl_category')
                ->whereIn('category_id', explode(',', $getAllRegionIDs))
                ->get()
                ->toArray();
        } else {
            $getAllRegion = DB::table('tbl_category')
                ->get()
                ->toArray();
        }
        return response()->json([
            'code' => 200,
            'getAllRegion' => $getAllRegion,
        ]);
    }
    public function getUnit(Request $request)
    {
        $getAllRegion = DB::table('tbl_category')
            ->where('parent_category_id', 1)
            ->select('category_id', 'category_name')
            ->get()
            ->toArray();

        return response()->json([
            'code' => 200,
            'getAllRegion' => $getAllRegion,
        ]);
    }

    public function getAllRegion($regionID)
    {
        $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
        $getAllRegion = DB::table('tbl_category')
            ->whereIn('category_id', explode(',', $getAllRegionIDs))
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'getAllRegion' => $getAllRegion,
        ]);
    }
    public function getChildren($parent_id)
    {
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $parent_id)
            ->get()
            ->toArray();
        global $children;
        foreach ($getRegion as $cat_value) {
            $children .= $cat_value->category_id . ',';
            $children = $this->getChildren($cat_value->category_id);
        }
        return $children;
    }
    public function getAgencyVisitCount(Request $request)
    {
        $agencyRegion = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$agencyRegion || !$fromDate || !$toDate) {
            return response()->json("agencyRegion ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getAgencyVisitCount = AgencyVisit::whereIn('agencyRegion', explode(',', $agencyRegion))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getAgencyVisitCount' => $getAgencyVisitCount,
        ]);
    }
    public function getRevisitCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Farmer region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getRevisitCount = DB::select("call gavl.getRevisitCount('$fromDate','$toDate','$regionIds')");
        return response()->json([
            'code' => 200,
            'getRevisitCount' => $getRevisitCount,
        ]);
    }
    public function getDealerCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Farmer region ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getDealerCount = DB::select("call gavl.getDealerCount('$fromDate','$toDate','$regionIds')");
        return response()->json([
            'code' => 200,
            'getDealerCount' => $getDealerCount,
        ]);
    }
    public function getLiquidationCount(Request $request)
    {
        $regionIds = $request->regionIds;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        if (!$regionIds || !$fromDate || !$toDate) {
            return response()->json("Employee ids, from and to date is required", Response::HTTP_BAD_REQUEST);
        }
        $getLiquidationCount = AgencyVisit::where('liquidation', 1)
            ->whereIn('agencyRegion', explode(',', $regionIds))
            ->whereBetween('visitDate', [$fromDate, $toDate])
            ->count();
        return response()->json([
            'code' => 200,
            'getLiquidationCount' => $getLiquidationCount,
        ]);
    }
    public function getOverallTargetReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();
        // dd($getRegion);
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $categoryID = $region->category_id;
                $categoryIDWithParent = $this->getRegionId($categoryID);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $getAllCountData = DB::table('tbl_activity_count_current_year')
                    ->selectRaw(
                        'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
                    )
                    ->whereBetween('activityDate', [$fromDate, $toDate])
                    ->whereIn('regionId', explode(',', $getAllRegionIDs))
                    ->get()
                    ->toArray();

                $data['region_name'] = $region->category_name . '-' . $categoryID;
                $data['ic_count'] = $getAllCountData[0]->ic_count ? $getAllCountData[0]->ic_count : 0;
                $data['sd_count'] = $getAllCountData[0]->sd_count ? $getAllCountData[0]->sd_count : 0;
                $data['sdv_count'] = $getAllCountData[0]->sdv_count ? $getAllCountData[0]->sdv_count : 0;
                $data['fd_count'] = $getAllCountData[0]->fd_count ? $getAllCountData[0]->fd_count : 0;
                $data['farmer_meet'] = $getAllCountData[0]->fm_count ? $getAllCountData[0]->fm_count : 0;
                $data['agency_visit'] = $getAllCountData[0]->av_count ? $getAllCountData[0]->av_count : 0;
                $data['revisit'] = $getAllCountData[0]->revisit_count ? $getAllCountData[0]->revisit_count : 0;
                $data['dealer_count'] = $getAllCountData[0]->dealer_profile_count ? $getAllCountData[0]->dealer_profile_count : 0;
                $data['liquidation_count'] = $getAllCountData[0]->liquidation_count ? $getAllCountData[0]->liquidation_count : 0;
                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();
            foreach ($getEmployee as $employee) {
                $getAllCountData = DB::table('tbl_emp_activity_count')
                    ->selectRaw(
                        'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
                    )
                    ->whereBetween('activityDate', [$fromDate, $toDate])
                    ->where('empId', $employee->id)
                    ->get()
                    ->toArray();

                $data['region_name'] = $employee->emp_name;
                $data['ic_count'] = $getAllCountData[0]->ic_count;
                $data['sd_count'] = $getAllCountData[0]->sd_count;
                $data['sdv_count'] = $getAllCountData[0]->sdv_count;
                $data['fd_count'] = $getAllCountData[0]->fd_count;
                $data['farmer_meet'] = $getAllCountData[0]->fm_count;
                $data['agency_visit'] = $getAllCountData[0]->av_count;
                $data['revisit'] = $getAllCountData[0]->revisit_count;
                $data['dealer_count'] = $getAllCountData[0]->dealer_profile_count;
                $data['liquidation_count'] = $getAllCountData[0]->liquidation_count;
                array_push($reportArray, $data);
            }
        }
        return response()->json([
            'code' => 200,
            'getOverallTargetReport' => $reportArray,
            'type' => $type,
        ]);
    }
    
    public function getactivitycountgraphical(Request $request)
{
    $regionID = $request->regionID;
    $fromDate = $request->from_date;
    $toDate = $request->to_date;

    $getRegions = DB::table('tbl_category')
        ->where('parent_category_id', $regionID)
        ->get()
        ->toArray();

    // Initialize arrays for each activity type
    $icreportArray = [];
    $sdreportArray = [];
    $sdvreportArray = [];
    $fdreportArray = [];
    $farmerMeetArray = [];
    $agencyVisitArray = [];
    $revisitArray = [];
    $dealerCountArray = [];
    $liquidationCountArray = [];

    foreach ($getRegions as $region) {
        $categoryID = $region->category_id;
        $categoryIDWithParent = $this->getRegionId($categoryID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $getAllCountData = DB::table('tbl_activity_count_current_year')
            ->selectRaw(
                'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->whereBetween('activityDate', [$fromDate, $toDate])
            ->whereIn('regionId', explode(',', $getAllRegionIDs))
            ->first();

        // Add region-wise data for each activity type
        $icreportArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->ic_count ?? 0];
        $sdreportArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->sd_count ?? 0];
        $sdvreportArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->sdv_count ?? 0];
        $fdreportArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->fd_count ?? 0];
        $farmerMeetArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->fm_count ?? 0];
        $agencyVisitArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->av_count ?? 0];
        $revisitArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->revisit_count ?? 0];
        $dealerCountArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->dealer_profile_count ?? 0];
        $liquidationCountArray[] = ['region' => $region->category_name, 'count' => $getAllCountData->liquidation_count ?? 0];
    }
// Fetching distributor count (agencyType = 2)
    $distributorCount = $this->getAgencyCountt($regionID, $request->search, [2]);

    // Fetching dealer count (agencyType = 1)
    $dealerCount = $this->getAgencyCountt($regionID, $request->search, [1]);

    // Code to get distributor and dealer count
    $distributorQuery = DB::table('tbl_agency as ta')
        ->whereIn('ta.agencyType', [2]);
    $dealerQuery = DB::table('tbl_agency as ta')
        ->whereIn('ta.agencyType', [1]);
    
    if ($regionID) {
        $getAllRegionIDs = $this->getRegionId($regionID);
        $distributorQuery = $distributorQuery->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
        $dealerQuery = $dealerQuery->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
    }

    $distributorCount = $distributorQuery->count();
    $dealerCount = $dealerQuery->count();
   $activeEmployeeCount = DB::table('tbl_employee')
                              ->where('deleteFlag', 0)
                              ->count();

    return response()->json([
        'code' => 200,
        
        'ic' => $icreportArray,
        'sd' => $sdreportArray,
        'sdv' => $sdvreportArray,
        'fd' => $fdreportArray,
        'farmer_meet' => $farmerMeetArray,
        'agency_visit' => $agencyVisitArray,
        'revisit' => $revisitArray,
        'distributorCount' => $distributorCount,
        'dealerCount' => $dealerCount,
        'activeEmployeeCount' => $activeEmployeeCount,
        'type' => 'region'
    ]);
}
private function getAgencyCountt($regionID, $search, $agencyTypes)
{
    $agencyQuery = DB::table('tbl_agency as ta');
    
    if ($search) {
        $agencyQuery = $agencyQuery->where('ta.agencyShopName', 'like', '%' . $search . '%');
    }

    if ($regionID) {
        $getAllRegionIDs = $this->getRegionId($regionID);
        $agencyQuery = $agencyQuery->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
    }

    return $agencyQuery
        ->whereIn('ta.agencyType', $agencyTypes)
        ->count();
}

    public function getEmpOverallTargetReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;

        $empIDs = $this->getEmployeeId($regionID);
        $reportArray = [];
        $getEmployee = DB::table('tbl_employee')
            ->where('deleteFlag', 0)
            ->get()
            ->pluck('emp_name', 'id')
            ->toArray();
        $getSearchedEmployee = DB::table('tbl_employee')
            ->where('emp_name', 'LIKE', '%' . $request->keyword . '%')
            ->where('deleteFlag', 0)
            ->get()
            ->pluck('id')
            ->toArray();
        $getAllCountData = DB::table('tbl_emp_activity_count');

        $getAllCountData = $getAllCountData
            ->selectRaw(
                'empID, sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->whereBetween('activityDate', [$fromDate, $toDate])
            ->whereIn('empID', $empIDs);
        if ($request->keyword) {
            $getAllCountData = $getAllCountData->where(function ($query) use ($getSearchedEmployee) {
                for ($i = 0; $i < count($getSearchedEmployee); $i++) {
                    $query->orwhere('empID', $getSearchedEmployee[$i]);
                }
            });
        }
        $getAllCountData = $getAllCountData->groupBy('empID');
        if ($request->paginate == "true") {
            $getAllCountData = $getAllCountData->paginate();
        } else {
            $getAllCountData = $getAllCountData->get()->toArray();
        }
        foreach ($getAllCountData as $employee) {
            $empId = $employee->empID;
            $data['employee_name'] = $getEmployee[$employee->empID];
            $data['ic_count'] = $employee->ic_count ? $employee->ic_count : 0;
            $data['sd_count'] = $employee->sd_count ? $employee->sd_count : 0;
            $data['sdv_count'] = $employee->sdv_count ? $employee->sdv_count : 0;
            $data['fd_count'] = $employee->fd_count ? $employee->fd_count : 0;
            $data['fm_count'] = $employee->fm_count ? $employee->fm_count : 0;
            $data['av_count'] = $employee->av_count ? $employee->av_count : 0;
            $data['revisit_count'] = $employee->revisit_count ? $employee->revisit_count : 0;
            $data['dealer_count'] = $employee->dealer_profile_count ? $employee->dealer_profile_count : 0;
            $data['liquidation_count'] = $employee->liquidation_count ? $employee->liquidation_count : 0;
            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'result' => $getAllCountData,
        ]);
    }
    public function getYTDTargetReport(Request $request)
    {
        $regionID = $request->regionID;
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();
        // dd($getRegion);
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $categoryID = $region->category_id;
                $categoryIDWithParent = $categoryID . ',' . $this->getChildren($categoryID);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $request['regionIds'] = $getAllRegionIDs;
                $data['region_name'] = $region->category_name . '-' . $categoryID;
                $data['ic_count'] = $this->getRegionIcCount($request)->getData()->getRegionIcCount;
                $data['sd_count'] = $this->getRegionSdCount($request)->getData()->getRegionSdCount[0]->totalCount;
                $data['sdv_count'] = $this->getRegionSdvCount($request)->getData()->getRegionSdvCount[0]->totalCount;
                $data['fd_count'] = $this->getRegionFdCount($request)->getData()->getRegionFdCount[0]->totalCount;
                $data['farmer_meet'] = $this->getRegionFMCount($request)->getData()->getRegionFMCount;
                $data['agency_visit'] = $this->getAgencyVisitCount($request)->getData()->getAgencyVisitCount;
                $data['revisit'] = $this->getRevisitCount($request)->getData()->getRevisitCount[0]->totalCount;
                $data['dealer_count'] = $this->getDealerCount($request)->getData()->getDealerCount[0]->totalCount;
                $data['liquidation_count'] = $this->getLiquidationCount($request)->getData()->getLiquidationCount;
                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();
            foreach ($getEmployee as $employee) {
                $request['regionIds'] = $regionID;
                $data['region_name'] = $employee->emp_name;
                $data['ic_count'] = $this->getRegionIcCount($request)->getData()->getRegionIcCount;
                $data['sd_count'] = $this->getRegionSdCount($request)->getData()->getRegionSdCount[0]->totalCount;
                $data['sdv_count'] = $this->getRegionSdvCount($request)->getData()->getRegionSdvCount[0]->totalCount;
                $data['fd_count'] = $this->getRegionFdCount($request)->getData()->getRegionFdCount[0]->totalCount;
                $data['farmer_meet'] = $this->getRegionFMCount($request)->getData()->getRegionFMCount;
                $data['agency_visit'] = $this->getAgencyVisitCount($request)->getData()->getAgencyVisitCount;
                $data['revisit'] = $this->getRevisitCount($request)->getData()->getRevisitCount[0]->totalCount;
                $data['dealer_count'] = $this->getDealerCount($request)->getData()->getDealerCount[0]->totalCount;
                $data['liquidation_count'] = $this->getLiquidationCount($request)->getData()->getLiquidationCount;
                array_push($reportArray, $data);
            }
        }
        return response()->json([
            'code' => 200,
            'getOverallTargetReport' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getEmployeeByRegionID($id)
    {
        $categoryIDWithParent = $id . ',' . $this->getChildren($id);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $getEmployee = DB::table('tbl_employee')
            ->where('deleteFlag', 0)
            ->where('user_role', 'employee')
            ->whereIn('region', explode(',', $getAllRegionIDs))
            ->get()
            ->pluck('emp_name', 'id')
            ->toArray();
        if(count($getEmployee)==0){
            $getEmployee = NULL;
        }
        return response()->json([
            'code' => 200,
            'allEmployee' => $getEmployee,
        ]);
    }
    public function getTeretoryByunitID($id)
    {
        $categoryIDWithParent = $id . ',' . $this->getChildren($id);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $getTeretory = DB::table('tbl_category')
            ->whereIn('parent_category_id', explode(',', $getAllRegionIDs))
            ->where('region_type', 3)
            ->pluck('category_name', 'category_id')
            ->toArray();

        return response()->json([
            'code' => 200,
            'allTeretory' => $getTeretory,
        ]);
    }

    //  public function getAgency(Request $request) {
    //     $perPage = $request->input('per_page', 50); // default to 50 results per page
    //     $page = $request->input('page', 1);
    //     $offset = ($page - 1) * $perPage;
    //     $query = DB::table('tbl_agency')->select('agencyShopName', 'agencyId')->offset($offset)->limit($perPage);
    //     $getAllAgency = $query->get();
    //     $total = $query->count();
    //     return response()->json([
    //         'code' => 200,
    //         'getAllAgency' => $getAllAgency,
    //         'total' => $total,
    //         'per_page' => $perPage,
    //         'current_page' => $page,
    //     ]);
    // }
    public function getAgency(Request $request)
    {
        // Cache::forget('users.page.' . $request->keyword);

        $getAllAgency = Cache::remember('users.page.' . $request->search, 300, function () use ($request) {
            $agencyType = isset($request->agencyType) && $request->agencyType ? [$request->agencyType] : [1, 2];
            $result = DB::table('tbl_agency as ta');
            if ($request->search) {
                $result = $result->where('ta.agencyShopName', 'like', '%' . $request->search . '%');
            }

            $result = $result
                ->select('agencyShopName', 'agencyId')
                ->whereIn('ta.agencyType', $agencyType)
                ->simplePaginate($request->limit);
            return $result;
        });

        // $getAllAgency = DB::table('tbl_agency')->select('agencyShopName', 'agencyId')->get()->toArray();
        return response()->json([
            'code' => 200,
            'getAllAgency' => $getAllAgency,
        ]);
    }
    
    public function getAgencyByRegionbackup(Request $request)
    {
        // Cache::forget('users.page.' . $request->keyword);

        // $getAllAgency = Cache::remember('users.page.' . $request->search, 300, function () use ($request) {
            $agencyType = isset($request->agencyType) && $request->agencyType ? [$request->agencyType] : [1, 2];
            $result = DB::table('tbl_agency as ta');
            if ($request->search) {
                $result = $result->where('ta.agencyShopName', 'like', '%' . $request->search . '%');
            }

            if ($request->regionID) {
                $getAllRegionIDs = $this->getRegionId($request->regionID);
                // dd($getAllRegionIDs);
                $result = $result->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
            }

            $result = $result
                ->select('agencyShopName', 'agencyId')
                ->whereIn('ta.agencyType', $agencyType)
                ->simplePaginate($request->limit);
            // return $result;
        // });

        // $getAllAgency = DB::table('tbl_agency')->select('agencyShopName', 'agencyId')->get()->toArray();
        return response()->json([
            'code' => 200,
            'getAllAgency' => $result,
        ]);
    }
    
    public function getAgencyByRegion(Request $request)
    {
        // Cache::forget('users.page.' . $request->keyword);

        // $getAllAgency = Cache::remember('users.page.' . $request->search, 300, function () use ($request) {
           
        
        $agencyType = isset($request->agencyType) && $request->agencyType ? [$request->agencyType] : [1, 2];
        
        $query = DB::table('tbl_agency as ta')
            ->select(
                DB::raw('CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName'),
                'agencyId'
            );
    
        if ($request->search) {
            $query->where('ta.agencyShopName', 'like', '%' . $request->search . '%');
        }
    
        if ($request->regionID) {
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $query->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
        }
    
        $query->whereIn('ta.agencyType', $agencyType);
    
        $perPage = $request->limit ?? 15;
        $page = $request->page ?? 1;
    
        $total = $query->count();
        $result = $query->offset(($page - 1) * $perPage)->limit($perPage)->get();
    
        $encodedResult = $result->map(function ($item) {
            return [
                'agencyShopName' => $item->agencyShopName,
                'agencyId' => $item->agencyId
            ];
        });
    
        $response = [
            'code' => 200,
            'getAllAgency' => [
                'current_page' => $page,
                'data' => $encodedResult,
                'total' => $total,
                'per_page' => $perPage,
                'last_page' => ceil($total / $perPage)
            ]
        ];
    
        return response()->json($response, 200, [], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
     
    private function ensureUtf8($text)
    {
        $encodings = ['UTF-8', 'ISO-8859-1', 'Windows-1252'];
        foreach ($encodings as $encoding) {
            $converted = @iconv($encoding, 'UTF-8//IGNORE', $text);
            if ($converted !== false) {
                return $converted;
            }
        }
        return $text;
    }
    public function getDistributorByRegion(Request $request)
    {
        // Cache::forget('users.page.' . $request->keyword);

        // $getAllAgency = Cache::remember('users.page.' . $request->search, 300, function () use ($request) {
            $agencyType = isset($request->agencyType) && $request->agencyType ? [$request->agencyType] : [2];
            $result = DB::table('tbl_agency as ta');
            if ($request->search) {
                $result = $result->where('ta.agencyShopName', 'like', '%' . $request->search . '%');
            }

            if ($request->regionID) {
                $getAllRegionIDs = $this->getRegionId($request->regionID);
                // dd($getAllRegionIDs);
                $result = $result->whereIn('agencyRegion', explode(',', $getAllRegionIDs));
            }

            $result = $result
                ->select('agencyShopName', 'agencyId')
                ->whereIn('ta.agencyType', $agencyType)
                ->simplePaginate($request->limit);
            // return $result;
        // });

        // $getAllAgency = DB::table('tbl_agency')->select('agencyShopName', 'agencyId')->get()->toArray();
        return response()->json([
            'code' => 200,
            'getAllAgency' => $result,
        ]);
    }
    
    public function count_target($empId, $tbl_name, $date)
    {
        $count = 0;
        $dataArray = [
            'count' => 0,
            'name' => '',
        ];
        if ($tbl_name == 'tbl_dealervisit') {
            $data = DB::select("SELECT * FROM `tbl_agencyvisit` WHERE `empId`='" . $empId . "' AND `visitDate` = '$date'");
            $keyName = 'agencyRegion';
        } else {
            $fromDate = $date . ' 00:00:00';
            $toDate = $date . ' 23:59:59';
            if ($tbl_name == 'tbl_farmerspotdemo') {
                //SD
                $data = DB::table('tbl_farmactivity as tfa')
                    ->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'tfa.farmerId')
                    ->select('tfa.farmerId', 'tf.farmerName')
                    ->where('tfa.empId', $empId)
                    ->where('tfa.SD_date', $date)
                    ->get()
                    ->toArray();
                $keyName = 'farmerName';
            } elseif ($tbl_name == 'tbl_farmerspotdemovisit') {
                //SDV
                $data = DB::table('tbl_farmactivity as tfa')
                    ->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'tfa.farmerId')
                    ->select('tf.farmerName', 'tf.farmerId')
                    ->where('tfa.empId', $empId)
                    ->where('tfa.SDV_date', $date)
                    ->get()
                    ->toArray();
                $keyName = 'farmerName';
            } elseif ($tbl_name == 'tbl_farmerfieldday') {
                //FD
                $data = DB::table('tbl_farmactivityFD as tfa')
                    ->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'tfa.farmerId')
                    ->select('tf.farmerName', 'tf.farmerId')
                    ->where('tfa.empId', $empId)
                    ->where('tfa.FD_date', $date)
                    ->get()
                    ->toArray();
                $dataArray['count'] = count($data);
                // $dataArray['name'] = $this->getName($data);
                $keyName = 'farmerName';
            } elseif ($tbl_name == 'tbl_farmervmeet') {
                //FM
                $data = DB::select("SELECT * FROM `tbl_farmermeeting` WHERE `empId`='" . $empId . "' AND `fmDate` = '$date'");
                $keyName = 'villageNameID';
            } elseif ($tbl_name == 'tbl_farmer') {
                //IC
                $data = DB::select("SELECT * FROM `tbl_farmer` WHERE `empId`='" . $empId . "' AND `farmerRegDate` = '$date'  AND delete_flag=0 ");
                $keyName = 'farmerName';
            } elseif ($tbl_name == 'tbl_revisit') {
                //IC
                $data = DB::select("SELECT * FROM `tbl_revisit`  WHERE empId='$empId' AND revisit_datetime BETWEEN '$fromDate' AND '$toDate'");
                $keyName = 'revisitPurpose';
            } elseif ($tbl_name == 'tbl_dealerprofile') {
                //dealer profile
                $data = DB::select(
                    "SELECT * FROM `tbl_agency` LEFT JOIN `tbl_agencydetail` ON `tbl_agency`.`agencyId` = `tbl_agencydetail`.`agencyId` WHERE `tbl_agencydetail`.`empId` = '$empId' AND `tbl_agency`.`agencyType` = 1 AND `tbl_agencydetail`.`date` = '$date'"
                );
                $keyName = 'agencyShopName';
            } elseif ($tbl_name == 'liquidation') {
                //dealer profile
                $data = DB::select("SELECT * FROM `tbl_agencyvisit` WHERE `liquidation` = '1' AND `visitDate` = '$date'  AND `empId`='" . $empId . "'");
                $keyName = 'agencyRegion';
            } elseif ($tbl_name == 'dealer_visit') {
                $data = DB::table('tbl_agencyvisit as tav')
                    ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                    ->select('ta.agencyShopName', 'ta.agencyId')
                    ->where('tav.empId', $empId)
                    ->where('tav.agencyType', 1)
                    ->where('tav.visitDate', $date)
                    ->get()
                    ->toArray();
                $keyName = 'agencyShopName';
            } elseif ($tbl_name == 'distributor_visit') {
                $data = DB::table('tbl_agencyvisit as tav')
                    ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                    ->select('ta.agencyShopName', 'ta.agencyId')
                    ->where('tav.empId', $empId)
                    ->where('tav.agencyType', 2)
                    ->where('tav.visitDate', $date)
                    ->get()
                    ->toArray();
                $keyName = 'agencyShopName';
            }
        }
        $dataArray['count'] = count($data);
        // $dataArray['name'] = $this->getName($data, $keyName);
        return $dataArray;
    }
    public function getEmpDayReport(Request $request)
    {
        $date = $request->date;
        $empId = $request->empID;
        $getPurposeList = $this->getPurposeList();
        // Get Employee Details
        $getEmployeeDetails = DB::table('tbl_employee as e')
            ->leftJoin('tbl_designation as td', 'e.empDesignation', '=', 'td.designationId')
            ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
            })
            ->leftJoin('tbl_category as tc', 'e.region', '=', 'tc.category_id')
            ->select('e.emp_name', 'td.designationName', 'tds.date', 'tds.stime', 'tds.etime', 'tc.category_name')
            ->where('e.id', $request->empID)
            ->get()
            ->toArray();

        // Get Agency Visit List
        $getAgencyData = AgencyVisit::where('empId', $request->empID)
            ->where('visitDate', $date)
            ->get();
        $agencyList = [];
        foreach ($getAgencyData as $value) {
            $visitPurpose = '';
            $visitPurposeArray = explode("#", $value->purpose);
            $visitCount = count($visitPurposeArray);

            foreach ($visitPurposeArray as $visitPurposeItem) {
                $key = array_search($visitPurposeItem, array_column($getPurposeList, 'purpose_agencyVisit_id'));
                if ($key !== false && isset($getPurposeList[$key]->purpose_agencyVisit_name)) {
                    $visitPurpose .= $getPurposeList[$key]->purpose_agencyVisit_name . ', ';
                }
            }
            $agencyData = DB::select(DB::raw("SELECT CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName, agencyMobile FROM tbl_agency WHERE agencyId='" . $value->agencyId . "'"));

            $data['agencyType'] = $value->agencyType == 1 ? 'Dealer' : 'Distributor';
            $data['agencyName'] = $agencyData[0]->agencyShopName;
            $data['agencyMobile'] = $agencyData[0]->agencyMobile;
            $data['visitPurpose'] = $visitPurpose;

            array_push($agencyList, $data);
        }

        // Get Daily Activity
        $dailyActivity = [];
        $dailyActivity[0]['ic'] = $this->count_target($empId, 'tbl_farmer', $date)['count'];
        $dailyActivity[0]['sd'] = $this->count_target($empId, 'tbl_farmerspotdemo', $date)['count'];
        $dailyActivity[0]['sdv'] = $this->count_target($empId, 'tbl_farmerspotdemovisit', $date)['count'];
        $dailyActivity[0]['fd'] = $this->count_target($empId, 'tbl_farmerfieldday', $date)['count'];
        $dailyActivity[0]['fm'] = $this->count_target($empId, 'tbl_farmervmeet', $date)['count'];
        $dailyActivity[0]['av'] = $this->count_target($empId, 'tbl_dealervisit', $date)['count'];
        $dailyActivity[0]['revisit'] = $this->count_target($empId, 'tbl_revisit', $date)['count'];
        $dailyActivity[0]['dealer_profile'] = $this->count_target($empId, 'tbl_dealerprofile', $date)['count'];
        $dailyActivity[0]['liquidation'] = 0;
        $dailyActivity[0]['dealer_visit'] = $this->count_target($empId, 'dealer_visit', $date)['count'];
        $dailyActivity[0]['distributor_visit'] = $this->count_target($empId, 'distributor_visit', $date)['count'];

        $dailyActivity[1]['ic'] = $this->count_target($empId, 'tbl_farmer', $date)['name'];
        $dailyActivity[1]['sd'] = $this->count_target($empId, 'tbl_farmerspotdemo', $date)['name'];
        $dailyActivity[1]['sdv'] = $this->count_target($empId, 'tbl_farmerspotdemovisit', $date)['name'];
        $dailyActivity[1]['fd'] = $this->count_target($empId, 'tbl_farmerfieldday', $date)['name'];
        $dailyActivity[1]['fm'] = $this->count_target($empId, 'tbl_farmervmeet', $date)['name'];
        $dailyActivity[1]['av'] = $this->count_target($empId, 'tbl_dealervisit', $date)['name'];
        $dailyActivity[1]['revisit'] = $this->count_target($empId, 'tbl_revisit', $date)['name'];
        $dailyActivity[1]['dealer_profile'] = $this->count_target($empId, 'tbl_dealerprofile', $date)['name'];
        $dailyActivity[1]['liquidation'] = 0;
        $dailyActivity[1]['dealer_visit'] = $this->count_target($empId, 'dealer_visit', $date)['name'];
        $dailyActivity[1]['distributor_visit'] = $this->count_target($empId, 'distributor_visit', $date)['name'];

        // Get Farmer Meeting
        $getFarmerMeetingData = FarmerMeeting::where('empId', $empId)
            ->where('fmDate', $date)
            ->get()
            ->toArray();

        $farmerMeeting = [];
        $villageName = '';
        $digiMeeting = 0;
        $groupMeeting = 0;
        $organisedMeeting = 0;
        $nightMeeting = 0;
        foreach ($getFarmerMeetingData as $value) {
            $villageName = $value['villageNameID'];
            if ($value['fmType'] == 4) {
                $digiMeeting += 1;
            }
            if ($value['fmType'] == 2) {
                $groupMeeting += 1;
            }
            if ($value['fmType'] == 3) {
                $organisedMeeting += 1;
            }
            if ($value['fmType'] == 1) {
                $nightMeeting += 1;
            }
        }

        $farmerMeeting['villageName'] = $villageName;
        $farmerMeeting['digiMeeting'] = $digiMeeting;
        $farmerMeeting['groupMeeting'] = $groupMeeting;
        $farmerMeeting['organisedMeeting'] = $organisedMeeting;
        $farmerMeeting['nightMeeting'] = $nightMeeting;

        // Get Order
        $orders = DB::table('tbl_ordernew as tp')
                    ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
                    ->leftJoin('tbl_agency as tc', function ($join) use ($date) {
                        $join->on('tp.did', '=', 'tc.agencyId')->where('tp.date', '=', $date);
                    })
                    ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
                    ->where('te.id', $empId)
                    ->where('tp.date', $date)
                    ->select(
                        'tp.oid',
                        'tp.date',
                        DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                        'te.emp_name',
                        'to.productName',
                        'tp.qty',
                        'tp.rate',
                        'tp.approval'
                    )
                    ->get();

        // Get Payment
        $payment = DB::table('tbl_payment as tp')
            ->leftJoin('tbl_employee as te', 'te.eid', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as tc', function ($join) use ($date) {
                $join->on('tp.dealerName', '=', 'tc.agencyId');
            })
            ->where('te.id', $empId)
            ->where('tp.chequeDate', $date)
            ->select(
                'tp.id',
                'tp.chequeDate',
                DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.bankName',
                'tp.chequeNo'
            )
            ->get();

        //   get ta/da and expense
        $tada = DB::table('tbl_tada as tfa')
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.uid')
            ->leftJoin('tbl_daystart as tc', function ($join) use ($date) {
                $join->on('tfa.uid', '=', 'tc.uid');
            })
            ->where('tf.deleteFlag', false)
            ->where('tfa.isReject', false)
            ->where('tf.id', $empId)
            ->where('tfa.tadaDate', $date)
            ->where('tc.date', $date)
            ->select(
                'tfa.id',
                'tf.emp_name',
                'tfa.tadaDate',
                'tfa.editableForm',
                'tfa.editableTo',
                'tfa.editableDistance',
                'tfa.editableMode',
                'tc.disgps',
                'tfa.editableExpense',
                'tfa.editableOtherExpense',
                'tfa.start_image',
                'tfa.end_image',
                'tf.ta',
                'tf.taCar',
                'tfa.da',
                'tfa.bill_img',
                'tfa.auto',
                'tfa.stationery',
                'tfa.vehmant',
                'tfa.petrol',
                'tfa.tada_pdf',
                'tfa.isApproved',
                'tc.sdis',
                'tc.edis',
                'tc.distance'
            )
            ->get();
        return response()->json([
            'code' => 200,
            'getEmployeeDetails' => $getEmployeeDetails,
            'agencyList' => $agencyList,
            'dailyActivity' => $dailyActivity,
            'farmerMeeting' => $farmerMeeting,
            'order' => $orders,
            'payment' => $payment,
            'tada' => $tada,
        ]);
    }

    // public function getLoginLogoutReport(Request $request)
    // {
    //     $regionId = $request->regionIndex;
    //     $date = $request->date;
    //     $empID = $request->empID;
    //     $categoryIDWithParent = $regionId . ',' . $this->getChildren($regionId);
    //     $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
    //     $regionIdArray = explode(',', $getAllRegionIDs);
    //     $regionIdArray = array_unique($regionIdArray);

    //     $getEmployeeDetails = DB::table('tbl_employee as e')
    //         ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
    //         ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
    //             $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
    //         })
    //         ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
    //         ->select('e.emp_name', 'td.designationName', 'tc.category_name', 'tds.stime', 'tds.etime', 'tds.date')
    //         ->whereIn('e.region', $regionIdArray);

    //     if ($request->keyword) {
    //         $getEmployeeDetails = $getEmployeeDetails->where(function ($query) use ($request) {
    //             $query->where('e.emp_name', 'like', '%' . $request->keyword . '%')
    //                 ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
    //         });
    //     }

    //     if ($empID) {
    //         $getEmployeeDetails = $getEmployeeDetails->where('tds.uid', $empID);
    //     }

    //     $getEmployeeDetails = $getEmployeeDetails->get();

    //     $empDetailsArray = [];
    //     foreach ($getEmployeeDetails as $value) {
    //         if ($value->date === $date) {
    //             $data['emp_name'] = $value->emp_name;
    //             $data['stime'] = $value->stime;
    //             $data['etime'] = $value->etime;
    //             $data['designationName'] = $value->designationName;
    //             $data['category_name'] = $value->category_name;
    //             array_push($empDetailsArray, $data);
    //         }
    //     }

    //     $collection = new Collection($empDetailsArray);

    //     $perPage = $request->input('per_page', 10);
    //     $currentPage = $request->input('page', 1);
    //     $paginator = new LengthAwarePaginator(
    //         $collection->forPage($currentPage, $perPage),
    //         $collection->count(),
    //         $perPage,
    //         $currentPage,
    //         ['path' => $request->url()]
    //     );

    //     return response()->json([
    //         'code' => 200,
    //         'getEmployeeDetails' => $paginator->toArray(),
    //     ]);
    // }
    public function getLoginLogoutReport(Request $request)
    {
        $regionId = $request->regionID;
        $date = $request->date;
        $empID = $request->empID;

        $result = DB::table('tbl_daystart as tds');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('e.emp_name', 'like', '%' . $request->keyword . '%')
                      ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%')
                      ->orWhere('td.designationName', 'like', '%' . $request->keyword . '%')
                      ->orWhere('tds.stime', 'like', '%' . $request->keyword . '%')
                      ->orWhere('tds.etime', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as e', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
            })
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->where('deleteflag', 0);

        if ($request->empID) {
            $result = $result->where('tds.uid', '=', $empID);
        }else{
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('e.region', explode(',', $getAllRegionIDs));
        }

        // Calculate the total count before paginating
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select('e.emp_name', 'td.designationName', 'tc.category_name', 'tds.stime', 'tds.etime', 'tds.date')->paginate();
        } else {
            $result = $result
                ->select('e.emp_name', 'td.designationName', 'tds.*', 'tc.*')
                ->get()
                ->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'total_records' => $totalCount, // Include the total count in the response
        ]);
    }
    //daywise daystart report
    public function daystartReport(Request $request)
    {
        $regionId = $request->regionID;
        $date = $request->date;
        $empID = $request->empID;

        $result = DB::table('tbl_employee as e');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('e.emp_name', 'like', '%' . $request->keyword . '%')->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
            })
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->where('deleteflag', 0);

        if ($request->regionID) {
            $regionId = $request->regionID;
            // $categoryIDWithParent = $regionId.','.$this->getRegionId($regionId);
            // $getAllRegionIDs = rtrim($categoryIDWithParent,',');
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('e.region', explode(',', $getAllRegionIDs));
        }
        // if ($regionId) {
        //     $regionIdArray = [$regionId]; // Convert $regionId to an array if required
        //     $result = $result->whereIn('e.region', $regionIdArray);
        // }

        if ($request->paginate == "true") {
            $result = $result->select('e.emp_name','e.eid','e.id as empId', 'tc.category_name', 'tds.id', 'tds.stime', 'tds.sdis', 'tds.sdis', 'tds.start_image', 'tds.etime', 'tds.edis', 'tds.end_image', 'tds.disgps', 'tds.date');
        } else {
            $result = $result->select('e.emp_name','e.eid', 'e.id as empId','td.designationName', 'tds.*', 'tc.*');
        }

        if ($date) {
            $dateRange = [$date, $date]; // Use the same date for both start and end of the range
            $result = $result->whereBetween('tds.date', $dateRange);
        }

        if ($empID) {
            $result = $result->where('e.id', $empID);
        }

        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    //daywise daystart performance report
    public function daystartPerformanaceReport(Request $request)
    {
        $regionId = $request->regionID;
        $date = $request->date;
        $empID = $request->empID;

        $result = DB::table('tbl_employee as e');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('e.emp_name', 'like', '%' . $request->keyword . '%')->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
            })
            ->leftJoin('tbl_activity_count_current_year as tac', function ($join) use ($date) {
                $join->on('e.id', '=', 'tac.empId')->where('tac.activityDate', '=', $date);
            })
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->where('deleteflag', 0);

        if ($request->regionID) {
            $regionId = $request->regionID;
            // $categoryIDWithParent = $regionId.','.$this->getRegionId($regionId);
            // $getAllRegionIDs = rtrim($categoryIDWithParent,',');
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('e.region', explode(',', $getAllRegionIDs));
        }
        // if ($regionId) {
        //     $regionIdArray = [$regionId]; // Convert $regionId to an array if required
        //     $result = $result->whereIn('e.region', $regionIdArray);
        // }

        if ($request->paginate == "true") {
            $result = $result->select('e.emp_name','e.eid','e.id as empId', 'tc.category_name', 'tds.id', 'tds.stime', 'tds.sdis', 'tds.sdis', 'tds.start_image', 'tds.etime', 'tds.edis', 'tds.end_image', 'tds.disgps', 'tds.date','tac.ic', 'tac.sd', 'tac.sdv', 'tac.fd', 'tac.fm', 'tac.ofm', 'tac.gfm', 'tac.av', 'tac.revisit', 'tac.payment', 'tac.order');
        } else {
            $result = $result->select('e.emp_name','e.eid', 'e.id as empId','td.designationName', 'tds.*', 'tc.*','tac.ic', 'tac.sd', 'tac.sdv', 'tac.fd', 'tac.fm', 'tac.ofm', 'tac.gfm', 'tac.av', 'tac.revisit', 'tac.payment', 'tac.order');
        }

        if ($date) {
            $dateRange = [$date, $date]; // Use the same date for both start and end of the range
            $result = $result->whereBetween('tds.date', $dateRange);
        }

        if ($empID) {
            $result = $result->where('e.id', $empID);
        }

        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    
    // monthly daywise day report
    public function monthlyDaystartReport(Request $request)
    {
        $regionId = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;

        $result = DB::table('tbl_daystart as tds');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query->where('e.emp_name', 'like', '%' . $request->keyword . '%')->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as e', 'e.id','=','tds.uid')
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->where('deleteflag', 0);

        if ($request->regionID) {
            $regionId = $request->regionID;
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('e.region', explode(',', $getAllRegionIDs));
        }
       
        if ($request->paginate == "true") {
            $result = $result->select('e.emp_name','e.eid','e.id as empId', 'tc.category_name','e.empDesignation', 'tds.id', 'tds.stime', 'tds.sdis', 'tds.sdis', 'tds.start_image', 'tds.etime', 'tds.edis', 'tds.end_image', 'tds.disgps', 'tds.date');
        } else {
            $result = $result->select('e.emp_name','e.eid', 'e.id as empId','td.designationName', 'tds.*', 'tc.*');
        }

        if ($request->timeFrameValue != "0") {
            $dateRange = [$fromDate, $toDate]; // Use the same date for both start and end of the range
            $result = $result->whereBetween('tds.date', $dateRange);
        }

        if ($empID) {
            $result = $result->where('e.id', $empID);
        }

        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    
    // Controller method
    public function deleteDayStart(Request $request)
    {
        try {
            $eid = $request->eid;
            $empId = $request->empId;
            $date = $request->date;
            $dayStart = DayStart::find($request->id);
            
            if (!$dayStart) {
                return response()->json(
                    [
                        'code' => 404,
                        'message' => "Day start not found",
                    ],
                    404
                );
            }
            
            if(!empty($eid) && (!empty($date)) && (!empty($empId))){
                $dayStart->delete();
                
                Track::where('eid', $eid)
                    ->where('date', $date)
                    ->delete();
                ActivityCount::where('empId', $empId)
                    ->where('activityDate', $date)
                    ->delete();
                LateLogin::where('empId', $empId)
                    ->where('date', $date)
                    ->delete();
            }else{
                return response()->json(
                    [
                        'code' => 201,
                        'message' => "Eid Or Date Missing",
                    ],
                    201
                );
            }

            return response()->json([
                'code' => 200,
                'message' => "Day start deleted successfully",
                'deletedId' => $dayStart->id,
            ]);
        } catch (\Exception $e) {
            return response()->json(
                [
                    'code' => 500,
                    'error' => $e->getMessage(),
                    'message' => "Something went wrong while deleting day start",
                ],
                500
            );
        }
    }

    public function getFeedbackReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        if ($regionID == 'all') {
            // $regionData = DB::table('tbl_category')->select('category_id','category_name')->where('parent_category_id','')->get()->pluck('category_name','category_id')->toArray();
            // $regionIdArray = [];
            // foreach ($regionData as $key => $value) {
            //   if ($value) {
            //     array_push($regionIdArray,$key);
            //   }
            // }
            $categoryIDWithParent = '1,' . $this->getChildren(1);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            // $regionIds = implode(',', $regionIdArray);
            $sql = "SELECT * FROM `tbl_feedback` t1 INNER JOIN (select agencyId,visitDate,visitId from `tbl_agencyvisit` group by agencyId) t2 ON t1.`visitId` = t2.visitId LEFT JOIN `tbl_agency` t3 ON t2.agencyId = t3.`agencyId` WHERE t3.`agencyRegion` IN ($getAllRegionIDs) AND t2.visitDate BETWEEN '$fromDate' and '$toDate'";
        } else {
            $sql =
                "SELECT * FROM `tbl_feedback` t1 INNER JOIN (select agencyId,visitDate,visitId from `tbl_agencyvisit` group by agencyId) t2 ON t1.`visitId` = t2.visitId LEFT JOIN `tbl_agency` t3 ON t2.agencyId = t3.`agencyId` WHERE t3.`agencyRegion` = '" .
                $regionID .
                "' AND t2.visitDate BETWEEN '$fromDate' and '$toDate'";
        }
        $data = DB::select($sql);
        return response()->json([
            'code' => 200,
            'feedback' => $data,
        ]);
    }

    public function getEmployeeId($employeeRegion)
    {
        $count = 0;
        $row = "";
        $sql = "WITH RECURSIVE mainCat AS (
            SELECT category_id, category_name, parent_category_id FROM tbl_category
            WHERE
            parent_category_id = $employeeRegion
            UNION ALL
            SELECT e.category_id,e.category_name, e.parent_category_id
            FROM
            tbl_category e
            INNER JOIN mainCat m ON e.parent_category_id = m.category_id )
            SELECT * FROM mainCat ORDER By `category_id` ASC";

        $getData = DB::select($sql);

        $ids = '';
        foreach ($getData as $value) {
            $ids .= $value->category_id . ',';
        }
        $ids = $ids . $employeeRegion;

        $getEmpIDs = Employee::whereIn('region', explode(',', $ids))
            ->where('deleteflag', 0)
            ->get()
            ->pluck('id')
            ->toArray();
        return $getEmpIDs;
    }

    public function getRegionId($id)
    {
        $count = 0;
        $row = "";
        $sql = "WITH RECURSIVE mainCat AS (
            SELECT category_id, category_name, parent_category_id FROM tbl_category
            WHERE
            parent_category_id = $id
            UNION ALL
            SELECT e.category_id,e.category_name, e.parent_category_id
            FROM
            tbl_category e
            INNER JOIN mainCat m ON e.parent_category_id = m.category_id )
            SELECT * FROM mainCat ORDER By `category_id` ASC";

        $getData = DB::select($sql);

        $ids = $id . ',';
        foreach ($getData as $value) {
            $ids .= $value->category_id . ',';
        }
        $ids = $ids . $id;
        $ids = rtrim($ids, ',');
        return $ids;
    }

    public function getActivityDetailReport(Request $request)
    {
        $regionId = $request->region;
        $activity = $request->activity;
        $productCategory = $request->productCat;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        $reportArray = [];
        $getAllEmployees = Employee::get()
            ->pluck('emp_name', 'id')
            ->toArray();
        $getAllCategory = DB::table('tbl_category')
            ->get()
            ->pluck('category_name', 'category_id')
            ->toArray();
        $getAllActivityFarmerFM = DB::table('tbl_activityfarmerFM')
            ->get()
            ->pluck('farmername', 'aid')
            ->toArray();
        $getAllActivityFarmerFM1 = DB::table('tbl_activityfarmerFM')
            ->get()
            ->pluck('mobileno', 'aid')
            ->toArray();
        // Return data from activity Agency Visit
        if ($activity == 'Agency Visit') {
            $empIDs = $this->getEmployeeId($regionId);
            $getData = DB::table('tbl_agencyvisit as tav')
                ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                ->select('tav.*', 'ta.*')
                ->whereBetween('tav.visitDate', [$fromDate, $toDate])
                ->whereIn('tav.agencyRegion', $empIDs)
                ->get()
                ->toArray();

            foreach ($getData as $value) {
                $purpose = '';
                if ($value->cropUpdate == 1) {
                    $purpose = 'Crop Update';
                } elseif ($value->liquidation == 1) {
                    $purpose = 'Liquidation';
                } elseif ($value->feedback == 1) {
                    $purpose = 'Feedback';
                } elseif ($value->collecttion == 1) {
                    $purpose = 'Collection';
                } elseif ($value->postHarvest == 1) {
                    $purpose = 'Post Harvest';
                }
                $reportData['agency_name'] = htmlspecialchars_decode($value->agencyName);
                $reportData['agency_type'] = $value->agencyType == 1 ? 'Dealer Visit' : 'Distributor Visit';
                $reportData['agency_region'] = $value->agencyRegion ? $getAllCategory[$value->agencyRegion] : '';
                $reportData['agency_mobile'] = $value->agencyMobile;
                $reportData['visit_date'] = $value->visitDate;
                $reportData['activity_performed_by'] = $getAllEmployees[$value->empId] . ' - ' . $activity;
                $reportData['purpose'] = $purpose;

                array_push($reportArray, $reportData);
            }
            return response()->json([
                'code' => 200,
                'report_data' => $reportArray,
            ]);
        }

        $gwtCropData = DB::table('tbl_crop')
            ->get()
            ->toArray();
        $i = 0;
        $cropData = [];
        foreach ($gwtCropData as $value) {
            $cropData[$i]['cropId'] = $value->cropId;
            $cropData[$i]['cropName'] = $value->cropName;
            $i++;
        }
        $getProductData = DB::table('tbl_activity_product')
            ->select('*')
            ->get()
            ->toArray();
        $i_product = 0;
        $productData = [];
        foreach ($getProductData as $value) {
            $productData[$i_product]['productId'] = $value->pid;
            $productData[$i_product]['productName'] = $value->productName;
            $i_product++;
        }
        if ($productCategory !== 'all') {
            $getProduct = DB::table('tbl_activity_product')
                ->select('*')
                ->where('productType', $productCategory)
                ->get()
                ->pluck('pid')
                ->toArray();
        } elseif ($productCategory === 'all') {
            $getProduct = DB::table('tbl_activity_product')
                ->select('*')
                ->get()
                ->pluck('pid')
                ->toArray();
        }
        $productIDs = implode(',', $getProduct);
        $pid = '';
        foreach ($getProduct as $value) {
            $pid .= "fmProductIds LIKE '" . $value . "%' OR ";
        }
        $pid1 = rtrim($pid, " OR");

        $query =
            "select  category_id, category_name, parent_category_id from (select * from tbl_category order by parent_category_id, category_id) tbl_category, (select @pv := " .
            $regionId .
            ") initialisation  where   find_in_set(parent_category_id, @pv) > 0 and @pv := concat(@pv, ',', category_id)";
        $result = DB::select($query);
        $cid = array_column($result, 'category_id');
        array_push($cid, $regionId);
        $getEmployee = Employee::whereIn('region', $cid)
            ->where('deleteFlag', 0)
            ->get()
            ->pluck('id')
            ->toArray();
        $empIDs = implode(',', $getEmployee);

        // $request1['empIds'] = $empIDs;
        // $request1['from_date'] = $fromDate;
        // $request1['to_date'] = $toDate;
        if ($activity == 'IC') {
            $sql = "SELECT * FROM `tbl_farmer` WHERE farmerRegDate between '$fromDate' AND '$toDate' AND empId IN ($empIDs)";
        } elseif ($activity == 'SD') {
            $sql = "SELECT * FROM `tbl_farmactivity` t1 LEFT JOIN `tbl_farmer` t2 ON t2.farmerId = t1.`farmerId` WHERE t1.SD_date between '$fromDate' AND '$toDate' AND t1.SD_Flag=1 AND t1.productId IN ($productIDs) AND t1.empId IN ($empIDs)";
        } elseif ($activity == 'SDV') {
            $sql = "SELECT * FROM `tbl_farmactivity` t1 LEFT JOIN `tbl_farmer` t2 ON t2.farmerId = t1.`farmerId` WHERE t1.SDV_date between '$fromDate' AND '$toDate' AND t1.SDV_Flag=1 AND t1.productId IN ($productIDs) AND t1.empId IN ($empIDs)";
        } elseif ($activity == 'FD') {
            $sql = "SELECT * FROM `tbl_farmactivityFD` t1 LEFT JOIN `tbl_farmer` t2 ON t2.farmerId = t1.`farmerId` WHERE t1.FD_date between '$fromDate' AND '$toDate' AND t1.productId IN ($productIDs) AND t1.empId IN ($empIDs)";
        } elseif ($activity == 'FM') {
            $sql = "SELECT * FROM `tbl_farmermeeting` t1 WHERE t1.fmDate between '$fromDate' AND '$toDate' AND ($pid1) AND t1.empId IN ($empIDs)";
        }
        if ($activity !== 'all' && $productCategory !== 'all') {
        } elseif ($activity !== 'all' && $productCategory === 'all') {
        } else {
            $sql = "SELECT * FROM `tbl_farmer` WHERE farmerId='0'";
        }

        $resultData = DB::select($sql);
        foreach ($resultData as $value) {
            if ($activity == 'IC') {
                $accBy = "";
            } elseif ($activity == 'SD') {
                $accBy = $value->accompanedBySD;
            } elseif ($activity == 'SDV') {
                $accBy = $value->accompanedBySDV;
            } elseif ($activity == 'FD') {
                $accBy = $value->accompanedByFD;
            } elseif ($activity == 'FM') {
                $accBy = $value->accompanied;
            }

            $accByIdValueList = "";
            $accById = [];
            if ($accBy) {
                $accById = explode('#', $accBy);
                foreach ($accById as $accByIdValue) {
                    if ($accByIdValue != "") {
                        $accByIdValueList .= $accByIdValue . ",";
                    }
                }
            }
            $idList = $accByIdValueList . $value->empId;
            $empArray = [];
            $i = 0;
            foreach (explode(',', $idList) as $idVal) {
                $empArray[$i]["empId"] = $idVal;
                $empArray[$i]["empName"] = $getAllEmployees[$idVal];
                $i++;
            }
            $empkey = array_search($value->empId, array_column($empArray, 'empId'));
            $activity_date = '';
            if ($activity == 'IC') {
                $activity_date = $value->farmerRegDate;
            } elseif ($activity == 'SD') {
                $activity_date = $value->SD_date;
            } elseif ($activity == 'SDV') {
                $activity_date = $value->SDV_date;
            } elseif ($activity == 'FD') {
                $activity_date = $value->FD_date;
            } elseif ($activity == 'FM') {
                $activity_date = $value->fmDate;
            }
            $acreage_covered = '';
            if ($activity == 'SD' || $activity == 'SDV') {
                $acreage_covered = $value->SD_Area;
            } elseif ($activity == 'FD') {
                $acreage_covered = $value->FD_Area;
            } elseif ($activity == 'IC') {
                $acreage_covered = $value->farmerLandAcerage;
            } else {
                $acreage_covered = "-";
            }
            $crop_name = '';
            if ($activity == 'IC') {
                $crop_name = '-';
            } elseif ($activity == 'FM') {
                $cid = explode('#', $value->fmCropIds);
                for ($j = 0; $j < count($cid); $j++) {
                    $key2 = '';
                    $key2 = array_search($cid[$j], array_column($cropData, 'cropId'));
                    if ($key2 === false) {
                        $crop_name = 'NA';
                    } else {
                        $crop_name = htmlspecialchars_decode($cropData[$key2]['cropName']) . '<br>';
                    }
                }
            } else {
                $cid = $value->cropId;
                $key2 = '';
                $key2 = array_search($cid, array_column($cropData, 'cropId'));
                if ($key2 === false) {
                    $crop_name = 'NA';
                } else {
                    $crop_name = htmlspecialchars_decode($cropData[$key2]['cropName']);
                }
            }
            $product_name = '';
            if ($activity == 'IC') {
                $product_name = '-';
            } elseif ($activity == 'FM') {
                $cid = explode('#', $value->fmProductIds);
                for ($j = 0; $j < count($cid); $j++) {
                    // $pid = $data['productId'];
                    $key = '';
                    $key = array_search($cid[$j], array_column($productData, 'productId'));
                    if ($key === false) {
                        $product_name = 'NA';
                    } else {
                        $product_name = htmlspecialchars_decode($productData[$key]['productName']) . "<br>";
                    }
                }
            } else {
                $pid = $value->productId;
                $key = '';
                $key = array_search($pid, array_column($productData, 'productId'));
                if ($key === false) {
                    $product_name = 'NA';
                } else {
                    $product_name = htmlspecialchars_decode($productData[$key]['productName']);
                }
            }
            $no_of_farmers = '';
            if ($activity == 'SD' || $activity == 'SDV') {
                $no_of_farmers = $value->SDV_farmerNumber;
            } elseif ($activity == 'FD') {
                $no_of_farmers = $value->FD_farmerNum;
            } elseif ($activity == 'FM') {
                $no_of_farmers = $value->fmNos;
            } else {
                $no_of_farmers = "-";
            }
            $activity_image = '';
            if ($activity == 'SD') {
                if ($value->SD_photo != '') {
                    $activity_image = 'https://s3.ap-south-1.amazonaws.com/upload.gavlconnect.in/' . $value->SD_photo;
                } else {
                    $activity_image = 'N/A';
                }
            } elseif ($activity == 'SDV') {
                if ($value->SDV_photo != '') {
                    $activity_image = 'https://s3.ap-south-1.amazonaws.com/upload.gavlconnect.in/' . $value->SDV_photo;
                } else {
                    $activity_image = 'N/A';
                }
            } else {
                $activity_image = 'N/A';
            }
            $reportData['activity_performed_by'] = $empkey === false ? 'NA' : htmlspecialchars_decode($empArray[$empkey]['empName']);
            $reportData['accompanied_by'] = 'NA';
            for ($j = 0; $j < count($accById); $j++) {
                $empId = $accById[$j];
                $key1 = '';
                $key1 = array_search($empId, array_column($empArray, 'empId'));
                if ($key1 === false) {
                    $reportData['accompanied_by'] = 'NA';
                    echo 'NA';
                } else {
                    $reportData['accompanied_by'] = htmlspecialchars_decode($empArray[$key1]['empName']);
                }
            }
            $reportData['farmer_region'] = $getAllCategory[$value->farmerRegion];
            $reportData['village_name'] = $activity == 'FM' ? htmlspecialchars_decode($value->villageNameID) : htmlspecialchars_decode($value->farmerCity);

            $reportData['farmer_name'] = '';
            if ($activity == 'FM' && isset($getAllActivityFarmerFM[$value->fmId])) {
                $reportData['farmer_name'] = htmlspecialchars_decode($getAllActivityFarmerFM[$value->fmId]);
            } elseif (isset($value->farmerName)) {
                $reportData['farmer_name'] = htmlspecialchars_decode($value->farmerName);
            }

            $reportData['farmer_contact'] = '';
            if ($activity == 'FM' && isset($getAllActivityFarmerFM1[$value->fmId])) {
                $reportData['farmer_contact'] = htmlspecialchars_decode($getAllActivityFarmerFM1[$value->fmId]);
            } elseif (isset($value->farmerMobile)) {
                $reportData['farmer_contact'] = htmlspecialchars_decode($value->farmerMobile);
            }

            $reportData['activity_date'] = $activity_date;
            $reportData['acreage_covered'] = $acreage_covered;
            $reportData['crop_name'] = $crop_name;
            $reportData['product_name'] = $product_name;
            $reportData['no_of_farmers'] = $no_of_farmers;
            $reportData['activity_image'] = $activity_image;

            array_push($reportArray, $reportData);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
        ]);
    }

    public function getIC($empID, $date)
    {
        $data = Farmer::select('farmerName')
            ->where('empId', $empID)
            ->where('farmerRegDate', $date)
            ->orderBy('farmerId', 'desc')
            ->get()
            ->toArray();
        $val = '';
        foreach ($data as $value) {
            $val .= htmlspecialchars_decode($value->farmerName);
        }
        return $val ? $val : 'N/A';
    }

    public function getCount($array, $id)
    {
        $json = json_encode($array);
        $decodedArray = json_decode($json, true);
        $key = array_search($id, array_column($decodedArray, 'empId'));

        return $key ? $decodedArray[$key]['totalCount'] : 0;
    }

    public function getActivityWiseDayReport($regionID, Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $empID = $request->empID;

            $query = "SELECT category_id, category_name, parent_category_id
                  FROM (
                      SELECT * FROM tbl_category ORDER BY parent_category_id, category_id
                  ) tbl_category, (
                      SELECT @pv := ?
                  ) initialisation
                  WHERE find_in_set(parent_category_id, @pv) > 0 AND @pv := concat(@pv, ',', category_id)";

            $result = DB::select($query, [$regionID]);
            $cid = array_column($result, 'category_id');
            array_push($cid, $regionID);

            $employeeQuery = Employee::whereIn('region', $cid)
                ->where('deleteFlag', 0)
                ->orderBy('id', 'asc');
            //  if ($keyword) {
            //     $employeeQuery->where('emp_name', 'LIKE', "%$keyword%");
            // }
            if ($empID) {
                $employeeQuery->where('id', $empID);
            }

            $totalRecords = $employeeQuery->count();
            $perPage = 10;
            $employees = $employeeQuery->simplePaginate($perPage);
            $getAllEmployees = $employees->pluck('emp_name', 'id');

            $empIDs = $getAllEmployees->keys();

            $getICData = Farmer::whereIn('empId', $empIDs)
                ->whereBetween('farmerRegDate', [$fromDate, $toDate])
                ->get()
                ->groupBy('empId')
                ->map(function ($group) {
                    return $group->count();
                })
                ->toArray();

            $getSDData = DB::table('tbl_farmactivity')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('SD_date', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $getSDVData = DB::table('tbl_farmactivity')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('SDV_date', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $getFDData = DB::table('tbl_farmactivityFD')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('FD_date', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $getDealerVisitData = DB::table('tbl_agencyvisit')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('visitDate', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->where('agencyType', 1)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $getDistributorVisitData = DB::table('tbl_agencyvisit')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('visitDate', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->where('agencyType', 2)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $getFMData = DB::table('tbl_farmermeeting')
                ->select('empId', DB::raw('COUNT(*) AS totalCount'))
                ->whereBetween('fmDate', [$fromDate, $toDate])
                ->whereIn('empId', $empIDs)
                ->groupBy('empId')
                ->pluck('totalCount', 'empId')
                ->toArray();

            $reportArray = [];
            foreach ($getAllEmployees as $key => $value) {
                $data['emp_name'] = $value;
                $data['emp_id'] = $key;
                $data['ic_count'] = isset($getICData[$key]) ? $getICData[$key] : 0;
                $data['sd_count'] = isset($getSDData[$key]) ? $getSDData[$key] : 0;
                $data['sdv_count'] = isset($getSDVData[$key]) ? $getSDVData[$key] : 0;
                $data['fd_count'] = isset($getFDData[$key]) ? $getFDData[$key] : 0;
                $data['dealer_visit_count'] = isset($getDealerVisitData[$key]) ? $getDealerVisitData[$key] : 0;
                $data['distributor_visit_count'] = isset($getDistributorVisitData[$key]) ? $getDistributorVisitData[$key] : 0;
                $data['fm_count'] = isset($getFMData[$key]) ? $getFMData[$key] : 0;

                $reportArray[] = $data;
            }

            return response()->json([
                'code' => 200,
                'total_records' => $totalRecords,
                'report_data' => $reportArray,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => 'An error occurred while generating the report.',
                'error' => $e->getMessage(),
            ]);
        }
    }

    public function calculateMonthCount($from, $to)
    {
        global $con;
        $date1 = $from;
        $date2 = $to;

        $ts1 = strtotime($date1);
        $ts2 = strtotime($date2);

        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);

        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);

        $diff = ($year2 - $year1) * 12 + ($month2 - $month1);
        return $diff + 1;
    }

    public function getWorkingDays($startDate, $endDate)
    {
        $endDate = strtotime($endDate);
        $startDate = strtotime($startDate);
        $days = ($endDate - $startDate) / 86400 + 1;

        $no_full_weeks = floor($days / 7);
        $no_remaining_days = fmod($days, 7);

        $the_first_day_of_week = date("N", $startDate);
        $the_last_day_of_week = date("N", $endDate);

        if ($the_first_day_of_week <= $the_last_day_of_week) {
            if ($the_first_day_of_week <= 6 && 6 <= $the_last_day_of_week) {
                $no_remaining_days--;
            }
            if ($the_first_day_of_week <= 7 && 7 <= $the_last_day_of_week) {
                $no_remaining_days--;
            }
        } else {
            if ($the_first_day_of_week == 7) {
                $no_remaining_days--;
                if ($the_last_day_of_week == 6) {
                    $no_remaining_days--;
                }
            } else {
                $no_remaining_days -= 2;
            }
        }
        $workingDays = $no_full_weeks * 5;
        if ($no_remaining_days > 0) {
            $workingDays += $no_remaining_days;
        }

        return $workingDays;
    }

    public function getAllTargetCount($AllEmployees, $getAllRegionIDs, $fromDate, $toDate, $type)
    {
        $count = 0;
        $daymonthcount = 0;
        $designationArray = [];
        if ($type == 'sd') {
            $designationArray = [
                10 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'sdv') {
            $designationArray = [
                20 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'fd') {
            $designationArray = [
                7 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'fm') {
            $designationArray = [
                4 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'ic') {
            $designationArray = [
                7 => [11, 12, 13, 14, 15, 16, 17],
                4 => [7, 8, 9, 10],
                2 => [6],
            ];
            $daymonthcount = $this->getWorkingDays($fromDate, $toDate);
        }

        foreach ($designationArray as $target => $desgnVal) {
            $empCount = 0;
            foreach ($AllEmployees as $value) {
                if ($type == 'sd' || $type == 'sdv' || $type == 'fd' || $type == 'fm') {
                    if (!in_array($value['empDesignation'], $desgnVal) && in_array($value['region'], explode(',', $getAllRegionIDs))) {
                        $empCount += 1;
                    }
                } else {
                    if (in_array($value['empDesignation'], $desgnVal) && in_array($value['region'], explode(',', $getAllRegionIDs))) {
                        $empCount += 1;
                    }
                }
            }
            $count += ceil($empCount) * $target * $daymonthcount;
        }
        return $count;
    }

    public function getAllEmpTargetCount($empDesignation, $fromDate, $toDate, $type)
    {
        $count = 0;
        $daymonthcount = 0;
        $designationArray = [];
        if ($type == 'sd') {
            $designationArray = [
                10 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'sdv') {
            $designationArray = [
                20 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'fd') {
            $designationArray = [
                7 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'fm') {
            $designationArray = [
                4 => [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24],
            ];
            $daymonthcount = $this->calculateMonthCount($fromDate, $toDate);
        } elseif ($type == 'ic') {
            $designationArray = [
                7 => [11, 12, 13, 14, 15, 16, 17],
                4 => [7, 8, 9, 10],
                2 => [6],
            ];
            $daymonthcount = $this->getWorkingDays($fromDate, $toDate);
        } elseif ($type == 'av') {
            $designationArray = [
                4 => [11, 12, 13, 14, 15, 16, 17, 7, 8, 9, 10, 6],
            ];
            $daymonthcount = $this->getWorkingDays($fromDate, $toDate);
        }

        $empCount = 1;
        foreach ($designationArray as $target => $desgnVal) {
            // echo "<pre>";
            // var_dump($desgnVal);
            // echo "</pre>";
            if ($type == 'sd' || $type == 'sdv' || $type == 'fd' || $type == 'fm') {
                $count += !in_array($empDesignation, $desgnVal) ? $empCount * $target * $daymonthcount : 0;
            } elseif ($type == 'ic' || $type == 'av') {
                // echo $count."="."</br>";
                if (in_array($empDesignation, $desgnVal)) {
                    // echo "true";
                    $count += $empCount * $target * $daymonthcount;
                } else {
                    // echo "false";
                    $count += 0;
                }
                // echo $count."-"."</br>";
            }
        }
        // dd('sadad');

        // for ($i=0; $i < count($designationArray); $i++) {
        //   if ($type == 'sd' || $type == 'sdv' || $type == 'fd' || $type == 'fm') {
        //     $count += !in_array($empDesignation, $desgnVal) ? $empCount*$target*$daymonthcount : 0;
        //   } else if($type == 'av') {
        //     // dd($daymonthcount);
        //     if (in_array($empDesignation, $desgnVal)) {
        //       $count += $empCount*$target*$daymonthcount;
        //     } else {
        //       $count += 0;
        //     }
        //   }
        // }
        return $count;
    }

    public function calculateAVTargetCount($getAllRegionIDs, $fromDate, $toDate)
    {
        $days = $this->getWorkingDays($fromDate, $toDate);
        $count = 0;
        $getAllEmployees = Employee::selectRaw('count(*) as designationCount, empDesignation')
            ->whereIn('region', explode(',', $getAllRegionIDs))
            ->where('deleteFlag', 0)
            ->groupBy('empDesignation')
            ->get()
            ->toArray();
        $designationCountarray = [];
        foreach ($getAllEmployees as $value) {
            $designationCountarray[] = ['empDesignation' => $value['empDesignation'], "designationCount" => $value['designationCount']];
        }

        $faDesignationArray = ['11', '12', '13', '14', '15', '16', '17'];

        for ($i = 0; $i < count($faDesignationArray); $i++) {
            foreach ($designationCountarray as $val) {
                if ($val['empDesignation'] == $faDesignationArray[$i]) {
                    $count += $val['designationCount'] * 4 * $days;
                }
            }
        }

        $offDesignationArray = [7, 8, 9, 10];

        for ($i = 0; $i < count($faDesignationArray); $i++) {
            foreach ($designationCountarray as $val) {
                if ($val['empDesignation'] == $faDesignationArray[$i]) {
                    $count += $val['designationCount'] * 4 * $days;
                }
            }
        }

        $tlDesignationArray = ['6'];

        for ($i = 0; $i < count($faDesignationArray); $i++) {
            foreach ($designationCountarray as $val) {
                if ($val['empDesignation'] == $faDesignationArray[$i]) {
                    $count += $val['designationCount'] * 4 * $days;
                }
            }
        }

        return $count;
    }

    public function viewtaget(Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $result = DB::table('tbl_activity_target as tfa')
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.empId')
            ->leftJoin('tbl_category as tcregion', 'tcregion.category_id', '=', 'tfa.regionId')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tf.region')
            ->leftJoin('tbl_category as tcterritory', 'tcterritory.category_id', '=', 'tfa.territory_id')
            // ->leftJoin('tbl_employee as te', 'te.region', '=', 'tfa.territory_id')
            ->leftJoin('tbl_category as tcunit', 'tcunit.category_id', '=', 'tc.unit') // Add this join for unit name
            ->where('tf.deleteFlag', false);

        if ($request->unitID) {
            $result = $result->where('tcunit.category_id', $request->unitID);
        }

        if ($request->territoryID) {
            $result = $result->where('tfa.territory_id', $request->territoryID);
        }
        if ($request->empID) {
            $result = $result->where('tfa.empId', $request->empID);
        }
        //   if ($request->timeFrameValue != "0") {
        //                 $result = $result->whereBetween('tfa.created_at',[$fromDate,$toDate]);
        //               }
        if ($request->paginate == "true") {
            $result = $result
                ->select(
                    'tfa.id',
                    'tcunit.category_name as unit_name', // Retrieve unit name
                    'tcterritory.category_name as territory_category_name',
                    'tf.emp_name',
                    //  'te.emp_name as territory_officer',
                    'tcregion.category_name as region_category_name',
                    'tf.phone',
                    'tfa.icTarget',
                    'tfa.sdTarget',
                    'tfa.sdvTarget',
                    'tfa.fdTarget',
                    'tfa.organisedMeetingTarget',
                    'tfa.groupMeetingTarget',
                    'tfa.avTarget'
                )
                ->simplePaginate();
        } else {
            $result = $result
                ->select(
                    'tfa.*',
                    'tf.emp_name',
                    'tcunit.category_name as unit_name' // Retrieve unit name
                )
                ->get()
                ->toArray();
        }

        // Rest of your code...

        return response()->json([
            'code' => 200,
            'message' => "Target fetched successfully",
            'data' => $result,
        ]);
    }

    public function viewAchievedTarget1(Request $request)
    {
        $result = DB::table('tbl_activity_target as tfa')
            ->leftJoin('tbl_employee as tf', 'tf.id', '=', 'tfa.empId')
            ->leftJoin('tbl_category as tcregion', 'tcregion.category_id', '=', 'tfa.regionId')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tf.region')
            ->leftJoin('tbl_category as tcterritory', 'tcterritory.category_id', '=', 'tfa.territory_id')
            ->leftJoin('tbl_category as tcunit', 'tcunit.category_id', '=', 'tc.unit')
            ->where('tf.deleteFlag', 0)
            ->select(
                'tfa.id',
                'tcunit.category_name as unit_name',
                'tcterritory.category_name as territory_category_name',
                'tf.emp_name',
                'tcregion.category_name as region_category_name',
                'tf.phone',
                'tfa.icTarget',
                'tfa.sdTarget',
                'tfa.sdvTarget',
                'tfa.fdTarget',
                'tfa.organisedMeetingTarget',
                'tfa.groupMeetingTarget',
                'tfa.avTarget'
            );

        if ($request->unitID) {
            $result = $result->where('tcunit.category_id', $request->unitID);
        }

        if ($request->territoryID) {
            $result = $result->where('tfa.territory_id', $request->territoryID);
        }

        if ($request->paginate == "true") {
            $perPage = 15; // Set your desired number of items per page
            $page = $request->page ?: 1;

            $countQuery = clone $result;
            $total = $countQuery->count();

            $paginator = new \Illuminate\Pagination\LengthAwarePaginator($result->forPage($page, $perPage)->get(), $total, $perPage, $page, [
                'path' => $request->url(),
                'query' => $request->query(),
            ]);

            $paginationDetails = [
                'current_page' => $paginator->currentPage(),
                'first_page_url' => $paginator->url(1),
                'from' => $paginator->firstItem(),
                'to' => $paginator->lastItem(),
                'last_page' => $paginator->lastPage(),
                'last_page_url' => $paginator->url($paginator->lastPage()),
                'next_page_url' => $paginator->nextPageUrl(),
                'path' => $paginator->path(),
                'per_page' => $paginator->perPage(),
                'prev_page_url' => $paginator->previousPageUrl(),
                'total' => $paginator->total(),
            ];

            $result = $paginator->items();
        } else {
            $result = $result->get()->toArray();
            $paginationDetails = null;
        }

        if ($request->territoryID == '') {
            $regionID = $request->unitID;
        } else {
            $regionID = $request->territoryID;
        }
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        $empIDs = $this->getEmployeeId($regionID);
        $reportArray = [];
        $getEmployee = DB::table('tbl_employee')
            ->where('deleteFlag', 0)
            ->pluck('emp_name', 'id')
            ->toArray();
        $getSearchedEmployee = DB::table('tbl_employee')
            ->where('emp_name', 'LIKE', '%' . $request->keyword . '%')
            ->where('deleteFlag', 0)
            ->pluck('id')
            ->toArray();
        $getAllCountData = DB::table('tbl_emp_activity_count');

        $getAllCountData = $getAllCountData
            ->selectRaw(
                'empID, sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
            )
            ->whereBetween('activityDate', [$fromDate, $toDate])
            ->whereIn('empID', $empIDs);
        if ($request->keyword) {
            $getAllCountData = $getAllCountData->whereIn('empID', $getSearchedEmployee);
        }
        $getAllCountData = $getAllCountData->groupBy('empID');
        if ($request->paginate == "true") {
            $getAllCountData = $getAllCountData->paginate();
        } else {
            $getAllCountData = $getAllCountData->get()->toArray();
        }
        foreach ($getAllCountData as $employee) {
            $empId = $employee->empID;
            $data['employee_name'] = $getEmployee[$employee->empID];
            $data['ic_count'] = $employee->ic_count ? $employee->ic_count : 0;
            $data['sd_count'] = $employee->sd_count ? $employee->sd_count : 0;
            $data['sdv_count'] = $employee->sdv_count ? $employee->sdv_count : 0;
            $data['fd_count'] = $employee->fd_count ? $employee->fd_count : 0;
            $data['fm_count'] = $employee->fm_count ? $employee->fm_count : 0;
            $data['av_count'] = $employee->av_count ? $employee->av_count : 0;
            $data['revisit_count'] = $employee->revisit_count ? $employee->revisit_count : 0;
            $data['dealer_count'] = $employee->dealer_profile_count ? $employee->dealer_profile_count : 0;
            $data['liquidation_count'] = $employee->liquidation_count ? $employee->liquidation_count : 0;
            $reportArray[] = $data;
        }

        return response()->json([
            'report_data' => $reportArray,
            'result' => $getAllCountData,
            'pagination_details' => $paginationDetails,
        ]);
    }

    public function FATarget($regionId, $fdate, $tdate)
    {
        $fetchTargetArray = [];
        $categoryType = 'te.id';
        $getRegionChild = $this->getChildren($regionId);
        $getRegionChild = rtrim($getRegionChild, ',');

        $results = DB::table('tbl_employee AS te')
            ->leftJoin('tbl_activity_target AS tat', 'tat.empId', '=', 'te.id')
            ->select(
                'te.region',
                DB::raw("$categoryType AS emp_id"),
                DB::raw('SUM(icTarget) AS icTarget'),
                DB::raw('SUM(sdTarget) AS sdTarget'),
                DB::raw('SUM(fdTarget) AS fdTarget'),
                DB::raw('SUM(organisedMeetingTarget) AS organisedMeetingTarget'),
                DB::raw('SUM(groupMeetingTarget) AS groupMeetingTarget'),
                DB::raw('SUM(avTarget) AS avTarget')
            )
            ->whereIn('empDesignation', [11, 12, 13, 14, 15, 16, 17, 26])
            ->where('tat.date_from', $fdate)
            ->where('tat.date_to', $tdate)
            ->groupBy($categoryType)
            ->get();

        foreach ($results as $row) {
            $ic_target = 0;
            $sd_target = 0;
            $fd_target = 0;
            $ofm_target = 0;
            $gfm_target = 0;
            $av_target = 0;

            $ic_target = $row->icTarget;
            $sd_target = $row->sdTarget;
            $fd_target = $row->fdTarget;
            $ofm_target = $row->organisedMeetingTarget;
            $gfm_target = $row->groupMeetingTarget;
            $av_target = $row->avTarget;
            $empId = $row->emp_id;

            $fetchTargetArray[] = [
                "regionId" => $row->region,
                "icTarget" => $ic_target,
                "sdTarget" => $sd_target,
                "fdTarget" => $fd_target,
                "organisedMeetingTarget" => $ofm_target,
                "groupMeetingTarget" => $gfm_target,
                "avTarget" => $av_target,
                "empId" => $empId,
            ];
        }
        return $fetchTargetArray;
    }

    public function FAAchieveTarget($regionId, $fdate, $tdate)
    {
        $fetchTargetAchiveArray = [];
        $categoryType = 'te.id';
        $getRegionChild = $this->getChildren($regionId);
        $getAllRegionIDs = rtrim($getRegionChild, ',');
        $results = DB::table('tbl_activity_count_current_year AS tat')
            ->leftJoin('tbl_employee AS te', 'tat.empId', '=', 'te.id')
            ->select(
                'te.region',
                DB::raw("$categoryType AS emp_id"),
                DB::raw('SUM(tat.ic) AS ic_achieved'),
                DB::raw('SUM(tat.revisit) AS revisit_achieved'),
                DB::raw('SUM(tat.sd) AS sd_achieved'),
                DB::raw('SUM(tat.fd) AS fd_achieved'),
                DB::raw('SUM(tat.ofm) AS ofm_achieved'),
                DB::raw('SUM(tat.gfm) AS gfm_achieved'),
                DB::raw('SUM(tat.av) AS av_achieved')
            )
            ->whereIn('empDesignation', [11, 12, 13, 14, 15, 16, 17, 26])
            ->whereIn('te.region', explode(',', $getAllRegionIDs))
            ->whereBetween('activityDate', [$fdate, $tdate])
            ->groupBy($categoryType)
            ->get();

        foreach ($results as $row) {
            $ic_achieved = 0;
            $sd_achieved = 0;
            $fd_achieved = 0;
            $ofm_achieved = 0;
            $gfm_achieved = 0;
            $av_achieved = 0;

            $icTotal = $row->ic_achieved + $row->revisit_achieved;
            $ic_achieved = $icTotal === null ? 0 : $icTotal;
            $sd_achieved = $row->sd_achieved === null ? 0 : $row->sd_achieved;
            $fd_achieved = $row->fd_achieved === null ? 0 : $row->fd_achieved;
            $ofm_achieved = $row->ofm_achieved === null ? 0 : $row->ofm_achieved;
            $gfm_achieved = $row->gfm_achieved === null ? 0 : $row->gfm_achieved;
            $av_achieved = $row->av_achieved === null ? 0 : $row->av_achieved;
            $empId = $row->emp_id;

            $fetchTargetAchiveArray[] = [
                "regionId" => $row->region,
                "ic_achieved" => $icTotal,
                "sd_achieved" => $sd_achieved,
                "fd_achieved" => $fd_achieved,
                "ofm_achieved" => $ofm_achieved,
                "gfm_achieved" => $gfm_achieved,
                "av_achieved" => $av_achieved,
                "empId" => $empId,
            ];
        }

        return $fetchTargetAchiveArray;
    }

    public function getEmployeeDataArray()
    {
        $queryr = DB::table('tbl_employee AS t1')
            ->select('t1.*', 'td.designationName AS designation_name')
            ->join('tbl_designation AS td', 'td.designationId', '=', 't1.empDesignation')
            ->where('t1.empDesignation', '!=', 24)
            ->where('t1.deleteFlag', 0)
            ->orderBy('t1.id')
            ->get();

        $arr = [];
        foreach ($queryr as $datar) {
            $arr[] = [
                'id' => $datar->id,
                'emp_name' => $datar->emp_name,
                'emp_mobile' => $datar->emp_mobile,
                'designation_id' => $datar->empDesignation,
                'designation_name' => $datar->designation_name,
                'region' => $datar->region,
            ];
        }

        return $arr;
    }

    public function getRegionDataArray()
    {
        $queryr = DB::table('tbl_category')
            ->where('category_name', '!=', '')
            ->get();

        $arr = [];
        foreach ($queryr as $datar) {
            $arr[] = [
                'category_id' => $datar->category_id,
                'category_name' => $datar->category_name,
                'parent_category_id' => $datar->parent_category_id,
                'unit' => $datar->unit,
                'region' => $datar->region,
                'territory' => $datar->territory,
                'headquarter' => $datar->headquarter,
                'empId' => $datar->empId,
                'region_type' => $datar->region_type,
            ];
        }

        return $arr;
    }

    public function viewAchievedTarget(Request $request)
    {
        if ($request->territoryID == '') {
            $regionID = $request->unitID;
        } else {
            $regionID = $request->territoryID;
        }
        $getFATargetVal = $this->FATarget($regionID, $request->fromDate, $request->toDate);
        $getFATargetAchiveArray = $this->FAAchieveTarget($regionID, $request->fromDate, $request->toDate);
        $getEmployeeDataArray = $this->getEmployeeDataArray($regionID, 4);

        $getRegionNameVal = $this->getRegionDataArray();
        $getEmployeeNameVal = $this->getEmployeeDataArray();

        // print_r($getEmployeeDataArray);

        $getAllRegionIDs = $this->getChildren($request->regionId);
        $getRegionChild = rtrim($getAllRegionIDs, ',');

        $result = DB::table('tbl_category AS t1')
            ->leftJoin('tbl_employee AS t2', 't1.empId', '=', 't2.id')
            ->select('t1.*', 't2.emp_name', 't2.emp_mobile', 't2.id', 't2.region')
            ->whereIn('t2.region', explode(',', $getRegionChild))
            ->whereIn('t2.empDesignation', [11, 12, 13, 14, 15, 16, 17, 26])
            ->where('t2.deleteFlag', 0);
        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('t2.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t2.emp_mobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('t1.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        if ($request->paginate == "true") {
            $perPage = 15; // Set your desired number of items per page
            $page = $request->page ?: 1;

            $countQuery = clone $result;
            $total = $countQuery->count();

            $paginator = new \Illuminate\Pagination\LengthAwarePaginator($result->forPage($page, $perPage)->get(), $total, $perPage, $page, [
                'path' => $request->url(),
                'query' => $request->query(),
            ]);

            $paginationDetails = [
                'current_page' => $paginator->currentPage(),
                'first_page_url' => $paginator->url(1),
                'from' => $paginator->firstItem(),
                'to' => $paginator->lastItem(),
                'last_page' => $paginator->lastPage(),
                'last_page_url' => $paginator->url($paginator->lastPage()),
                'next_page_url' => $paginator->nextPageUrl(),
                'path' => $paginator->path(),
                'per_page' => $paginator->perPage(),
                'prev_page_url' => $paginator->previousPageUrl(),
                'total' => $paginator->total(),
            ];

            $result = $paginator->items();
        } else {
            $result = $result->get()->toArray();
            $paginationDetails = null;
        }

        foreach ($result as $row) {
            $icTarget = '0';
            $sdTarget = '0';
            $fdTarget = '0';
            $ofmTarget = '0';
            $gfmTarget = '0';
            $avTarget = '0';
            // echo $row['eid'];
            if ($row->id) {
                $key = '';
                $key = array_search($row->id, array_column($getFATargetVal, 'empId'));
                if ($key === false) {
                    $icTarget = '0';
                    $sdTarget = '0';
                    $fdTarget = '0';
                    $ofmTarget = '0';
                    $gfmTarget = '0';
                    $avTarget = '0';
                } else {
                    $icTarget = $getFATargetVal[$key]['icTarget'];
                    $sdTarget = $getFATargetVal[$key]['sdTarget'];
                    $fdTarget = $getFATargetVal[$key]['fdTarget'];
                    $ofmTarget = $getFATargetVal[$key]['organisedMeetingTarget'];
                    $gfmTarget = $getFATargetVal[$key]['groupMeetingTarget'];
                    $avTarget = $getFATargetVal[$key]['avTarget'];
                }
            }
            // echo $icTarget;
            $icAchiveTarget = '0';
            $sdAchiveTarget = '0';
            $fdAchiveTarget = '0';
            $ofmAchiveTarget = '0';
            $gfmAchiveTarget = '0';
            $avAchiveTarget = '0';
            if ($row->id) {
                $key = '';
                $key = array_search($row->id, array_column($getFATargetAchiveArray, 'empId'));
                if ($key === false) {
                    $icAchiveTarget = '0';
                    $sdAchiveTarget = '0';
                    $fdAchiveTarget = '0';
                    $ofmAchiveTarget = '0';
                    $gfmAchiveTarget = '0';
                    $avAchiveTarget = '0';
                } else {
                    $icAchiveTarget = $getFATargetAchiveArray[$key]['ic_achieved'];
                    $sdAchiveTarget = $getFATargetAchiveArray[$key]['sd_achieved'];
                    $fdAchiveTarget = $getFATargetAchiveArray[$key]['fd_achieved'];
                    $ofmAchiveTarget = $getFATargetAchiveArray[$key]['ofm_achieved'];
                    $gfmAchiveTarget = $getFATargetAchiveArray[$key]['gfm_achieved'];
                    $avAchiveTarget = $getFATargetAchiveArray[$key]['av_achieved'];
                }
            }

            $workRegionName = '';
            if ($row->region) {
                $key = '';
                $key = array_search($row->region, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $workRegionName = '';
                } else {
                    $workRegionName = $getRegionNameVal[$key]['category_name'];
                    $territoryId = $getRegionNameVal[$key]['territory'];
                    $unitId = $getRegionNameVal[$key]['unit'];
                }
            }
            $unitName = '';
            if ($unitId) {
                $key = '';
                $key = array_search($unitId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $unitName = '';
                } else {
                    $unitName = $getRegionNameVal[$key]['category_name'];
                }
            }
            // print_r($getRegionNameVal);
            $territoryName = '';
            if ($territoryId) {
                $key = '';
                $key = array_search($territoryId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $territoryName = '';
                } else {
                    $territoryName = $getRegionNameVal[$key]['category_name'];
                    $tlId = $getRegionNameVal[$key]['empId'];
                }
            }

            $TLName = '';
            // echo $tlId;
            if ($tlId) {
                $key = '';
                $key = array_search($tlId, array_column($getEmployeeNameVal, 'id'));
                if ($key === false) {
                    $TLName = '';
                } else {
                    $TLName = $getEmployeeNameVal[$key]['emp_name'];
                }
            }

            // $empId = $row>empID;
            $data['unit'] = $unitName;
            $data['territoryName'] = $territoryName;
            $data['territoryIncharge'] = $TLName;
            $data['workRegion'] = $workRegionName;
            $data['emp_name'] = $row->emp_name;
            $data['emp_mobile'] = $row->emp_mobile;
            $data['eid'] = $row->id;
            $data['ic_target'] = $icTarget;
            $data['ic_achieve'] = $icAchiveTarget;
            $data['sd_target'] = $sdTarget;
            $data['sd_achieve'] = $sdAchiveTarget;
            $data['fd_target'] = $fdTarget;
            $data['fd_achieve'] = $fdAchiveTarget;
            $data['ofm_target'] = $ofmTarget;
            $data['ofm_achieve'] = $ofmAchiveTarget;
            $data['gfm_target'] = $gfmTarget;
            $data['gfm_achieve'] = $gfmAchiveTarget;
            $data['av_target'] = $avTarget;
            $data['av_achieve'] = $avAchiveTarget;
            $reportArray[] = $data;
        }

        return response()->json([
            'report_data' => $reportArray,
            'pagination_details' => $paginationDetails,
        ]);
    }

    public function getRegionWiseTargetReport($regionID, Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $categoryData = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->orderBy('category_name', 'asc')
            ->get()
            ->toArray();
        $reportArray = [];
        $getAllEmployees = Employee::select('region', 'empDesignation')
            ->where('deleteFlag', 0)
            ->get()
            ->toArray();
        foreach ($categoryData as $value) {
            $categoryIDWithParent = $value->category_id . ',' . $this->getChildren($value->category_id);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $request['regionIds'] = $getAllRegionIDs;
            $request['from_date'] = $fromDate;
            $request['to_date'] = $toDate;

            $data['region_name'] = $value->category_name;
            $data['ic_target_count'] = (int) $this->getAllTargetCount($getAllEmployees, $getAllRegionIDs, $fromDate, $toDate, 'ic');
            $data['ic_count'] = $this->getRegionIcCount($request)->getData()->getRegionIcCount;
            $data['sd_target_count'] = (int) $this->getAllTargetCount($getAllEmployees, $getAllRegionIDs, $fromDate, $toDate, 'sd');
            $data['sd_count'] = $this->getRegionSdCount($request)->getData()->getRegionSdCount[0]->totalCount;
            $data['sdv_target_count'] = (int) $this->getAllTargetCount($getAllEmployees, $getAllRegionIDs, $fromDate, $toDate, 'sdv');
            $data['sdv_count'] = $this->getRegionSdvCount($request)->getData()->getRegionSdvCount[0]->totalCount;
            $data['fd_target_count'] = (int) $this->getAllTargetCount($getAllEmployees, $getAllRegionIDs, $fromDate, $toDate, 'fd');
            $data['fd_count'] = $this->getRegionFdCount($request)->getData()->getRegionFdCount[0]->totalCount;
            $data['fm_target_count'] = (int) $this->getAllTargetCount($getAllEmployees, $getAllRegionIDs, $fromDate, $toDate, 'fm');
            $data['fm_count'] = $this->getRegionFMCount($request)->getData()->getRegionFMCount;
            $data['av_target_count'] = (int) $this->calculateAVTargetCount($getAllRegionIDs, $fromDate, $toDate);
            $data['av_count'] = $this->getAgencyVisitCount($request)->getData()->getAgencyVisitCount;

            array_push($reportArray, $data);
        }

        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
        ]);
    }
    public function getEmpTagetCount($tableData, $type, $empID)
    {
        $count = 0;
        if ($type == 'ic' || $type == 'fm' || $type == 'av') {
            foreach ($tableData as $value) {
                if ($empID == $value['empId']) {
                    $count += 1;
                }
            }
        } elseif ($type == 'fd' || $type == 'sd' || $type == 'sdv') {
            foreach ($tableData as $value) {
                if ($empID == $value->empId) {
                    $count += 1;
                }
            }
        }
        return $count;
    }
    public function getEmployeeWiseTartgetReport($regionID, Request $request)
    {
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;

        $categoryIDWithParent = $regionID . ',' . $this->getChildren($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        if ($empID == 'all') {
            $getEmployeeDetails = Employee::select('id', 'emp_name', 'region', 'empDesignation')
                ->whereIn('region', explode(',', $getAllRegionIDs))
                ->whereNotIn('empDesignation', [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24])
                ->where('deleteFlag', 0)
                ->limit(10)
                ->get()
                ->toArray();
        } else {
            $getEmployeeDetails = Employee::select('id', 'emp_name', 'region', 'empDesignation')
                ->where('id', $empID)
                ->whereNotIn('empDesignation', [1, 2, 3, 4, 5, 18, 19, 20, 21, 22, 23, 24])
                ->where('deleteFlag', 0)
                ->get()
                ->toArray();
        }

        // dd($getEmployeeDetails);
        $reportArray = [];
        $farmerData = Farmer::whereBetween('farmerRegDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        $tableFarmerSDData = DB::select("SELECT * FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SD_date` BETWEEN '$fromDate' AND '$toDate'");
        $tableFarmerSDVData = DB::select("SELECT * FROM `tbl_farmactivity` LEFT JOIN `tbl_farmer` ON `tbl_farmactivity`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `SDV_date` BETWEEN '$fromDate' AND '$toDate'");
        $tableFarmerFDData = DB::select("SELECT * FROM `tbl_farmactivityFD` LEFT JOIN `tbl_farmer` ON `tbl_farmactivityFD`.`farmerId` = `tbl_farmer`.`farmerId` WHERE `FD_date` BETWEEN '$fromDate' AND '$toDate'");
        $tableFarmerFMData = FarmerMeeting::whereBetween('fmDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        $tableFarmerAVData = AgencyVisit::whereBetween('visitDate', [$fromDate, $toDate])
            ->get()
            ->toArray();
        foreach ($getEmployeeDetails as $employee) {
            $data['emp_name'] = $employee['emp_name'];
            $data['ic_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'ic');
            $data['ic_count'] = $this->getEmpTagetCount($farmerData, 'ic', $employee['id']);
            $data['sd_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'sd');
            $data['sd_count'] = $this->getEmpTagetCount($tableFarmerSDData, 'sd', $employee['id']);
            $data['sdv_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'sdv');
            $data['sdv_count'] = $this->getEmpTagetCount($tableFarmerSDVData, 'sdv', $employee['id']);
            $data['fd_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'fd');
            $data['fd_count'] = $this->getEmpTagetCount($tableFarmerFDData, 'fd', $employee['id']);
            $data['fm_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'fm');
            $data['fm_count'] = $this->getEmpTagetCount($tableFarmerFMData, 'fm', $employee['id']);
            $data['av_target_count'] = (int) $this->getAllEmpTargetCount($employee['empDesignation'], $fromDate, $toDate, 'av');
            $data['av_count'] = $this->getEmpTagetCount($tableFarmerAVData, 'av', $employee['id']);
            // dd($data);
            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
        ]);
    }
    // public function getAgencyCount($regionID)
    // {
    //     $categoryIDWithParent = $regionID . ',' . $this->getChildren($regionID);
    //     $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

    //     $agencyVisitData = AgencyVisit::selectRaw('COUNT(*) as count, agencyId')
    //         ->groupBy('agencyId', 'agencyId')
    //         ->get()
    //         ->toArray();
    //     $agencyVisitArray = [];
    //     foreach ($agencyVisitData as $value) {
    //         $agencyVisitArray[$value['agencyId']] = $value['count'];
    //     }
    //     $getAllCategory = DB::table('tbl_category')
    //         ->get()
    //         ->pluck('category_name', 'category_id')
    //         ->toArray();
    //     $agencyData = Agency::whereIn('agencyRegion', explode(',', $getAllRegionIDs))
    //         ->get()
    //         ->toArray();

    //     $reportArray = [];
    //     foreach ($agencyData as $value) {
    //         $data['agency_name'] = $value['agencyName'];
    //         $data['agency_shop_name'] = $value['agencyShopName'];
    //         $data['agency_mobile'] = $value['agencyMobile'];
    //         $data['agency_address'] = $value['agencyAddress'];
    //         $data['agency_region'] = $getAllCategory[$value['agencyRegion']];
    //         $data['agency_type'] = $value['agencyType'] == 1 ? 'Dealer' : 'Distributor';
    //         $data['agency_visit_count'] = array_key_exists($value['agencyId'], $agencyVisitArray) ? $agencyVisitArray[$value['agencyId']] : 0;

    //         array_push($reportArray, $data);
    //     }
    //     return response()->json([
    //         'code' => 200,
    //         'report_data' => $reportArray,
    //     ]);
    // }
    public function getAgencyCount(Request $request) 
    {
        $result = DB::table('tbl_agency as ta')
            ->leftJoin('tbl_agencydetail as tad', 'tad.agencyId', '=', 'ta.agencyId')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'ta.agencyRegion');

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        
        $result = $result->where('ta.approvstatus', 1);
        
        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('ta.agencyName', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        if ($request->regionIndex) {
            $getAllRegionIDs = $this->getRegionId($request->regionIndex);
            $result = $result->whereIn('ta.agencyRegion', explode(',', $getAllRegionIDs));
        }

        if ($request->empID) {
            $result = $result->where('tad.empId', $request->empID);
        }

        // Calculate the total count before paginating
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result
                ->select('ta.agencyId',  DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),  DB::raw("CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName"), 'ta.agencyMobile',  DB::raw("CONVERT(CAST(CONVERT(ta.agencyAddress USING latin1) AS BINARY) USING utf8mb4) as agencyAddress"), 'tcc.category_name', 'ta.agencyType',  'ta.lastVisitDateTime')
                ->simplePaginate();
        } else {
            $result = $result
                ->select('ta.*', 'tcc.category_name')
                ->get()
                ->toArray();
        }

        $agencyVisitData = AgencyVisit::selectRaw('COUNT(*) as count, agencyId, MAX(visitDate) as lastVisitDate')
            ->groupBy('agencyId', 'agencyId');
            
        if ($request->timeFrameValue != "0") {
            $agencyVisitData = $agencyVisitData->whereBetween('visitDate', [$fromDate, $toDate]);
        }    
        
        $agencyVisitData =  $agencyVisitData->get()->toArray();

        $agencyVisitArray = [];
        foreach ($agencyVisitData as $value) {
            $agencyVisitArray[$value['agencyId']] = $value['count'];
        }
        $agencyVisitDateArray = [];
        foreach ($agencyVisitData as $value) {
            $agencyVisitDateArray[$value['agencyId']] = $value['lastVisitDate'];
        }

        $visitCountArray = [];
        $visitDateArray = [];
        foreach ($result as $value) {
            $visitCountArray[$value->agencyId] = array_key_exists($value->agencyId, $agencyVisitArray) ? $agencyVisitArray[$value->agencyId] : 0;
            $visitDateArray[$value->agencyId] = array_key_exists($value->agencyId, $agencyVisitDateArray) ? $agencyVisitDateArray[$value->agencyId] : 'N/A';
            $value->agency_type = $value->agencyType == 1 ? 'Dealer' : 'Distributor';
        }

        return response()->json([
            'code' => 200,
            'message' => "Agency count fetched successfully",
            'total_records' => $totalCount, // Include the total count in the response
            'agency_visit_count' => $visitCountArray,
            'agency_visit_date' => $visitDateArray,
            'data' => $result,
        ]);
    }

    public function getActivityCountOld(Request $request)
    {
        try {
            // Extract empID and date range from the request
            $empID = $request->empID;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            // Query to get the latest activity date within the specified date range and group by empId
            $latestActivityDatesQuery = DB::table('tbl_activity_count_current_year')
                ->select('empId', DB::raw('MAX(activityDate) AS max_activityDate'))
                ->whereBetween('activityDate', [$fromDate, $toDate])
                ->groupBy('empId');

            // Calculate the total record count based on the latest activity date within the date range
            $totalRecordsByLatestActivityDate = $latestActivityDatesQuery->count();

            // Pagination
            $paginate = $request->paginate === "true";
            $page = $request->page ?? 1;
            $perPage = 10; // Number of items per page

            // Query to get the detailed data including activity counts
            $resultQuery = DB::table('tbl_activity_count_current_year as tfd')
                ->leftJoin('tbl_employee as te', 'tfd.empId', '=', 'te.id')
                ->whereIn('tfd.empId', function ($query) use ($latestActivityDatesQuery) {
                    $query->select('empId')->fromSub($latestActivityDatesQuery, 'latest_dates');
                })
                ->where('tfd.empId', $empID) // Filter by empID
                ->whereBetween('tfd.activityDate', [$fromDate, $toDate]); // Date range filter

            $result = $resultQuery
                ->select(
                    'te.emp_name',
                    DB::raw('SUM(tfd.ic) AS ic_count'),
                    DB::raw('SUM(tfd.sd) AS sd_count'),
                    DB::raw('SUM(tfd.sdv) AS sdv_count'),
                    DB::raw('SUM(tfd.fd) AS fd_count'),
                    DB::raw('SUM(tfd.av) AS av_count'),
                    DB::raw('SUM(tfd.revisit) AS revisit_count'),
                    DB::raw('SUM(tfd.fm) AS fm_count')
                )
                ->groupBy('te.emp_name', 'tfd.empId')
                ->when(
                    $paginate,
                    function ($query) use ($perPage, $page) {
                        return $query->simplePaginate($perPage, ['*'], 'page', $page);
                    },
                    function ($query) {
                        return $query->get();
                    }
                );
            if ($request->keyword) {
                $result = $result->where(function ($query) use ($request) {
                    $query
                        ->where('te.emp_name', 'like', '%' . $request->keyword . '%')
                        ->orWhere('te.emp_mobile', 'like', '%' . $request->keyword . '%');
                });
            }
            // Calculate the total count of active employees
            $activeEmployeeCount = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->count();

            return response()->json([
                'code' => 200,
                'message' => "Activity count fetched successfully",
                'total_records_by_latest_activity_date' => $totalRecordsByLatestActivityDate, // Total records based on the latest activity date in the specified date range
                'active_employees' => $activeEmployeeCount,
                'data' => $result,
            ]);
        } catch (\Exception $e) {
            // Handle exceptions...
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    public function getActivityCount(Request $request){
        try {
            // Extract empID and date range from the request
            $empID = $request->empID;
            $regionID = $request->regionID;
            if ($request->timeFrameValue != "0") {
                $fromDate = $request->fromDate;
                $toDate = $request->toDate;
            } else {
                $fromDate = date('Y-m-d');
                $toDate = date('Y-m-d');
            }
        
            $search = $request->keyword;
        
            $latestActivityDatesQuery = DB::table('tbl_activity_count_current_year')
                ->select('empId', DB::raw('MAX(activityDate) AS max_activityDate'))
                ->whereBetween('activityDate', [$fromDate, $toDate])
                ->groupBy('empId');
        
            $totalRecordsByLatestActivityDate = $latestActivityDatesQuery->count();
        
            $resultQuery = DB::table('tbl_employee as te')
                ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
                ->leftJoin('tbl_activity_count_current_year as tfd', function ($join) use ($fromDate, $toDate) {
                    $join->on('te.id', '=', 'tfd.empId')
                        ->whereBetween('tfd.activityDate', [$fromDate, $toDate]);
                })
                ->groupBy('te.emp_name', 'te.id')
                ->where('te.deleteFlag', '0');
        
            if ($empID !== null) {
                $resultQuery = $resultQuery->where('te.id', $empID);
            }else{
                $getAllRegionIDs = $this->getRegionId($regionID);
                $resultQuery = $resultQuery->whereIn('te.region', explode(',', $getAllRegionIDs));
            }
        
            if ($search) {
                $resultQuery->where(function ($query) use ($search) {
                    $query->where('te.emp_name', 'LIKE', "%$search%");
                    $query->orWhere('te.emp_mobile', 'LIKE', "%$search%");
                    $query->orWhere('tc.category_name', 'LIKE', "%$search%");
                });
            }
        
            $result = $resultQuery
                ->select(
                    'te.emp_name',
                    'te.emp_mobile',
                    'tc.category_name',
                    DB::raw('COALESCE(SUM(tfd.ic), 0) AS ic_count'),
                    DB::raw('COALESCE(SUM(tfd.sd), 0) AS sd_count'),
                    DB::raw('COALESCE(SUM(tfd.sdv), 0) AS sdv_count'),
                    DB::raw('COALESCE(SUM(tfd.fd), 0) AS fd_count'),
                    DB::raw('COALESCE(SUM(tfd.av), 0) AS av_count'),
                    DB::raw('COALESCE(SUM(tfd.revisit), 0) AS revisit_count'),
                    DB::raw('COALESCE(SUM(tfd.fm), 0) AS fm_count')
                ); // Apply pagination with 10 records per page
            
            if($request->paginate == 'true'){
                $result = $result->paginate(15);
            }else{
                $result = $result->get();
            }
        
            $activeEmployeeCount = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->count();
        
            return response()->json([
                'code' => 200,
                'message' => "Activity count fetched successfully",
                'total_records_by_latest_activity_date' => $totalRecordsByLatestActivityDate,
                'active_employees' => $activeEmployeeCount,
                'data' => $result,
            ]);
        
        } catch (\Exception $e) {
            // Handle exceptions...
            return response()->json([
                'code' => 500,
                'error' => $e->getMessage(),
                'message' => "Something went wrong while fetching data",
            ]);
        }

    }

    function createDateRangeArray($strDateFrom, $strDateTo)
    {
        // takes two dates formatted as YYYY-MM-DD and creates an
        // inclusive array of the dates between the from and to dates.

        // could test validity of dates here but I'm already doing
        // that in the main script

        $aryRange = [];

        $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
            while ($iDateFrom < $iDateTo) {
                $iDateFrom += 86400; // add 24 hours
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }
        return $aryRange;
    }
    public function getregionwiseAttendanceReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $endDate = $request->end_date;
        $dateRange = $this->createDateRangeArray($fromDate, $toDate);
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();

        $reportArray = [];
        $type = '';

        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $regionId = $region->category_id;
                $empIDs = $this->getEmployeeId($regionId);
                $dayStartData = DayStart::selectRaw('COUNT(*) as count, date')
                    ->whereIn('uid', $empIDs)
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->groupBy('date', 'date')
                    ->get()
                    ->pluck('count', 'date')
                    ->toArray();

                $data['region_name'] = $region->category_name . '-' . $regionId;
                foreach ($dateRange as $value) {
                    $data[date('jn', strtotime($value))] = array_key_exists($value, $dayStartData) ? $dayStartData[$value] : 0;
                }
                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';

            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();

            foreach ($getEmployee as $employee) {
                $empID = $employee->emp_id; // Corrected variable name to empID
                $dayStartData = DayStart::selectRaw('COUNT(*) as count, date')
                    ->where('uid', $empID) // Corrected variable name to empID
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->groupBy('date', 'date')
                    ->get()
                    ->pluck('count', 'date')
                    ->toArray();

                $data['region_name'] = $employee->emp_name;
                foreach ($dateRange as $value) {
                    $data[date('jn', strtotime($value))] = array_key_exists($value, $dayStartData) ? $dayStartData[$value] : 0;
                }
                array_push($reportArray, $data);
            }
        }

        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getAttendanceReportTest(Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $empID = $request->empID;
            $regionID = $request->regionID;

            $reportArray = [];

            $query = DB::table('tbl_employee as e')
                ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
                ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
                ->leftJoin('tbl_daystart as tds', function ($join) use ($fromDate, $toDate) {
                    $join->on('e.id', '=', 'tds.uid');
                    $join->whereBetween('tds.date', [$fromDate, $toDate]);
                })
                ->where('deleteFlag', 0);

            if ($request->regionID) {
                $regionId = $request->regionID;
                $categoryIDWithParent = $regionId . ',' . $this->getRegionId($regionId);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $query = $query->whereIn('e.region', explode(',', $getAllRegionIDs));
            }else{
                $query = $query->where('e.id', $empID);
            }

            if ($request->keyword) {
                $query->where(function ($q) use ($request) {
                    $q
                        ->where('e.emp_name', 'like', '%' . $request->keyword . '%')
                        ->orWhere('e.manager_emp_code', 'like', '%' . $request->keyword . '%')
                        ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $query->select('e.id', 'e.emp_name', 'e.emp_mobile', 'td.designationName as empDesignation', 'e.manager_emp_code', 'tc.category_name', 'e.state', 'tds.date', 'tds.stime');

            foreach ($query->get() as $record) {
                $regionData = [
                    'id' => $record->id,
                    'emp_name' => $record->emp_name,
                    'empDesignation' => $record->empDesignation,
                    'category_name' => $record->category_name,
                    'state' => $record->state,
                    'daystart_records' => [],
                ];

                if ($record->date && $record->stime) {
                    $dayStartData = [
                        'date' => $record->date,
                        'stime' => $record->stime,
                    ];

                    $existingEmployeeIndex = array_search($record->id, array_column($reportArray, 'id'));

                    if ($existingEmployeeIndex !== false) {
                        $reportArray[$existingEmployeeIndex]['daystart_records'][] = $dayStartData;
                    } else {
                        $regionData['daystart_records'][] = $dayStartData;
                        $reportArray[] = $regionData;
                    }
                } else {
                    $regionData['daystart_records'] = [];
                    $reportArray[] = $regionData;
                }
            }

            $totalRecords = count($reportArray);
            $perPage = 15;
            $currentPage = $request->page ?? 1;
            $lastPage = ceil($totalRecords / $perPage);
            $startIndex = ($currentPage - 1) * $perPage;

            if ($request->paginate == 'false') {
                $paginatedData = $reportArray;
            } else {
                $paginatedData = array_slice($reportArray, $startIndex, $perPage);
            }

            $response = [
                'code' => 200,
                'data' => $paginatedData,
                'current_page' => $currentPage,
                'from' => $startIndex + 1,
                'to' => min($startIndex + $perPage, $totalRecords),
                'per_page' => $perPage,
                'total' => $totalRecords,
                'last_page' => $lastPage,
            ];

            if ($currentPage > 1) {
                $response['prev_page_url'] = url("/your-api-endpoint?page=" . ($currentPage - 1));
            }

            if ($currentPage < $lastPage) {
                $response['next_page_url'] = url("/your-api-endpoint?page=" . ($currentPage + 1));
            }

            return response()->json($response);
        } catch (\Exception $e) {
            // Handle exceptions...
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }
    
    public function getAttendanceReport(Request $request)
    {
        // try {
            
            $empID = $request->empID;
            $regionID = $request->regionID;
            
            if ($request->timeFrameValue != "0") {
                $fromDate = $request->fromDate;
                $toDate = $request->toDate;
            } else {
                $fromDate = date('Y-m-01');
                $toDate = date('Y-m-d');
            }

            $reportArray = [];

            $query = DB::table('tbl_employee as e')
                ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
                ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
                ->leftJoin('tbl_daystart as tds', function ($join) use ($fromDate, $toDate) {
                    $join->on('e.id', '=', 'tds.uid');
                    $join->whereBetween('tds.date', [$fromDate, $toDate]);
                })
                ->where('user_role', 'employee')
                ->where('deleteFlag', 0);

            if ($request->empID) {
                $query = $query->where('e.id', $empID);
            }else{
                $regionId = $request->regionID;
                $categoryIDWithParent = $regionId . ',' . $this->getRegionId($regionId);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $query = $query->whereIn('e.region', explode(',', $getAllRegionIDs));
            }

            if ($request->keyword) {
                $query->where(function ($q) use ($request) {
                    $q
                        ->where('e.emp_name', 'like', '%' . $request->keyword . '%')
                        ->orWhere('e.manager_emp_code', 'like', '%' . $request->keyword . '%')
                        ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $query->select('e.id', 'e.emp_name','e.region', 'e.emp_mobile', 'td.designationName as empDesignation', 'e.manager_emp_code', 'tc.category_name', 'e.state', 'tds.date', 'tds.stime');

            foreach ($query->get() as $record) {
                $leaveDateArray = [];
                $leaveDateArray = DB::table('tbl_leave_application_details')
                    ->selectRaw('leave_date')
                    ->where('emp_id', $record->id)
                    ->whereBetween('leave_date', [$fromDate, $toDate])
                    ->orderBy('leave_date', 'asc')
                    ->get()
                    ->pluck('leave_date'); 
                    
                $lateLoginDateArray = [];
                 
                $lateLoginDateArray = DB::table('tbl_daystart')
                    ->selectRaw('date')
                    ->where('uid', $record->id)
                    ->whereRaw("CAST(`stime` AS TIME) > '09:00:00'")
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->orderBy('date', 'asc')
                    ->get()
                    ->pluck('date');
                
                $inputCategoryId = $record->region; // Replace with your desired category_id
                if($inputCategoryId == 1){
                    $unitId = 1;
                }else{
                    $unitResult = DB::select(DB::raw("SELECT FindImportantCategory(?) as unitName"), [$inputCategoryId]);
                    // print_r($unitResult);
                    // Access the result
                    $unitName = $unitResult[0]->unitName;
                    
                    $category = Category::where('category_name', $unitName)->first();
                    if ($category) {
                        $unitId = $category->category_id;
                    } else {
                        $unitId = '';
                    }
                }
                
                // Create Carbon instances from the start and end dates
                $startDate = Carbon::parse($fromDate);
                $endDate = Carbon::parse($toDate);
                
                $sundays = [];
                
                // Loop through the dates and identify Sundays
                while ($startDate->lte($endDate)) {
                    if ($startDate->dayOfWeek === Carbon::SUNDAY) {
                        $sundays[] = $startDate->toDateString();
                    }
                    $startDate->addDay();
                }
                
                if ($unitId == 1) {
                    $holidayDateArray = DB::table('tbl_holydaycalender')
                        ->selectRaw('date')
                        ->whereBetween('date', [$fromDate, $toDate])
                        ->where('isDeleted', '0')
                        ->get()
                        ->pluck('date')
                        ->toArray(); 
                } else {
                    $holidayDateArray = DB::table('tbl_holydaycalender')
                        ->selectRaw('date')
                        ->where('region', $unitId)
                        ->where('isDeleted', '0')
                        ->whereBetween('date', [$fromDate, $toDate])
                        ->get()
                        ->pluck('date')
                        ->toArray(); 
                }
                                
                // Merge the $sundays array with $holidayDateArray
                $mergedDates = array_merge($sundays, $holidayDateArray);

                
                // if($unitId == 1){
                //     $holidayDateArray = DB::table('tbl_holydaycalender')
                //     ->selectRaw('date')
                //     ->whereBetween('date', [$fromDate, $toDate])
                //     ->where('isDeleted', '0')
                //     ->get()
                //     ->pluck('date');
                // }else{
                //     $holidayDateArray = DB::table('tbl_holydaycalender')
                //     ->selectRaw('date')
                //     ->where('region', $unitId)
                //     ->where('isDeleted', '0')
                //     ->whereBetween('date', [$fromDate, $toDate])
                //     ->get()
                //     ->pluck('date');
                // }
                    
                $regionData = [
                    'id' => $record->id,
                    'emp_name' => $record->emp_name,
                    'empDesignation' => $record->empDesignation,
                    'category_name' => $record->category_name,
                    'state' => $record->state,
                    'unit' => $unitId,
                    'daystart_records' => [],
                    'leave_date' => $leaveDateArray,
                    'holyday_date' => $mergedDates,
                    'lateLogin_date' => $lateLoginDateArray,
                ];
                
                $eid = $record->id; 

                if ($record->date && $record->stime) {
                    $dayStartData = [
                        'date' => $record->date,
                        'stime' => $record->stime,
                    ];

                    $existingEmployeeIndex = array_search($record->id, array_column($reportArray, 'id'));

                    if ($existingEmployeeIndex !== false) {
                        $reportArray[$existingEmployeeIndex]['daystart_records'][] = $dayStartData;
                    } else {
                        $regionData['daystart_records'][] = $dayStartData;
                        $reportArray[] = $regionData;
                    }
                } else {
                    $regionData['daystart_records'] = [];
                    $reportArray[] = $regionData;
                }
            }

            $totalRecords = count($reportArray);
            $perPage = 15;
            $currentPage = $request->page ?? 1;
            $lastPage = ceil($totalRecords / $perPage);
            $startIndex = ($currentPage - 1) * $perPage;

            if ($request->paginate == 'false') {
                $paginatedData = $reportArray;
            } else {
                $paginatedData = array_slice($reportArray, $startIndex, $perPage);
            }

            $response = [
                'code' => 200,
                'data' => $paginatedData,
                'current_page' => $currentPage,
                'from' => $startIndex + 1,
                'to' => min($startIndex + $perPage, $totalRecords),
                'per_page' => $perPage,
                'total' => $totalRecords,
                'last_page' => $lastPage,
            ];

            if ($currentPage > 1) {
                $response['prev_page_url'] = url("/your-api-endpoint?page=" . ($currentPage - 1));
            }

            if ($currentPage < $lastPage) {
                $response['next_page_url'] = url("/your-api-endpoint?page=" . ($currentPage + 1));
            }

            return response()->json($response);
        // } catch (\Exception $e) {
        //     // Handle exceptions...
        //     return response()->json([
        //         'code' => 500,
        //         'message' => "Something went wrong while fetching data",
        //     ]);
        // }
    }

    // public function getAttendanceReport(Request $request)
    // {
    //     $regionID = $request->regionID;
    //     $fromDate = $request->fromDate;
    //     $toDate = $request->toDate;
    //     $empID = $request->empID;
    //     $paginate = $request->paginate;

    //     $query = DB::table('tbl_employee as e')
    //         ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
    //         ->leftJoin('tbl_daystart as tds', function ($join) use ($fromDate, $toDate) {
    //             $join->on('e.id', '=', 'tds.uid');
    //             $join->whereBetween('tds.date', [$fromDate, $toDate]);
    //         })
    //         ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
    //         ->whereBetween('tds.date', [$fromDate, $toDate]);

    //     if ($request->keyword) {
    //         $query->where(function ($q) use ($request) {
    //             $q->where('e.emp_name', 'like', '%' . $request->keyword . '%')
    //                 ->orWhere('e.manager_emp_code', 'like', '%' . $request->keyword . '%')
    //                 ->orWhere('tc.category_name', 'like', '%' . $request->keyword . '%');
    //         });
    //     }

    //     if ($request->regionID) {
    //         $query->where('e.region', $request->regionID);
    //     }

    //     if ($request->empID) {
    //         $query->where('e.id', $request->empID);
    //     }

    //     $query->select('e.id', 'e.emp_name', 'e.emp_mobile', 'td.designationName as empDesignation','e.manager_emp_code', 'tc.category_name', 'e.state', 'tds.date', 'tds.stime');

    //     if ($paginate) {
    //         $page = $request->page ?? 1;
    //         $perPage = 10; // Number of records per page

    //         $result = $query->paginate($perPage, ['*'], 'page', $page);
    //     } else {
    //         $result = $query->get();
    //     }

    //     // Modify the result to group daystart records by employee ID
    //     $modifiedResult = [];
    //     foreach ($result as $record) {
    //         $employeeId = $record->id;
    //         if (!isset($modifiedResult[$employeeId])) {
    //             $modifiedResult[$employeeId] = [
    //                 'id' => $record->id,
    //                 'emp_name' => $record->emp_name,
    //                 'empDesignation' => $record->empDesignation,
    //                 'category_name' => $record->category_name, // Add category_name field
    //               'state' => $record->state, // Add state field
    //                 'daystart_records' => []
    //             ];
    //         }

    //         $modifiedResult[$employeeId]['daystart_records'][] = [
    //             'date' => $record->date,
    //             'stime' => $record->stime
    //         ];
    //     }

    //     $categoryData = DB::table('tbl_category')
    //         ->pluck('category_name', 'category_id')
    //         ->toArray();

    //     return response()->json([
    //         'code' => 200,
    //         'report_data' => array_values($modifiedResult), // Convert associative array to indexed array
    //         'category_data' => $categoryData,
    //         'pagination' => [
    //             'current_page' => $result->currentPage(),
    //             'last_page' => $result->lastPage(),
    //             'per_page' => $result->perPage(),
    //             'total' => $result->total(),
    //         ],
    //     ]);
    // }

    public function getOverallAttendanceReport(Request $request)
    {
        $date = $request->date;
        $regionID = $request->regionID;
        $categoryData = DB::table('tbl_category')
            ->get()
            ->pluck('category_name', 'category_id')
            ->toArray();
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();
        $reportArray = [];
        foreach ($getRegion as $value) {
            $categoryID = $value->category_id;
            $empIDs = $this->getEmployeeId($categoryID);

            $dayStart = DayStart::select('*')
                ->whereIn('uid', $empIDs)
                ->where('date', $date)
                ->count();

            $data['region_name'] = $categoryData[$categoryID] . '-' . $categoryID;
            $data['unit'] = $categoryData[$regionID];
            $data['total'] = count($empIDs);
            $data['present'] = $dayStart;
            $data['absent'] = count($empIDs) - $dayStart;

            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
        ]);
    }

    public function viewFMDetails($fmID)
    {
        $fmData = DB::table('tbl_farmermeeting as tfm')
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tfm.empId')
            ->leftJoin('tbl_meeting as tm', 'tm.meeting_id', '=', 'tfm.fmType')
            ->select('tfm.fmId', 'tfm.fmDate', 'te.emp_name', 'tm.meeting_name', 'tfm.fmRemark', 'tfm.fmNos', 'tfm.fmCropIds', 'tfm.fmProductIds')
            ->where('tfm.fmId', explode(',', $fmID))
            ->get()
            ->toArray();

        $fmDetails = [];
        foreach ($fmData as $value) {
            $cropData = DB::table('tbl_crop')
                ->select('cropName')
                ->whereIn('cropId', explode('#', $value->fmCropIds))
                ->get()
                ->toArray();
            $productData = DB::table('tbl_product')
                ->select('productName')
                ->whereIn('pid', explode('#', $value->fmProductIds))
                ->get()
                ->toArray();
            $data['fmDate'] = $value->fmDate;
            $data['emp_name'] = $value->emp_name;
            $data['meeting_name'] = $value->meeting_name;
            $data['fmRemark'] = $value->fmRemark;
            $data['fmNos'] = $value->fmNos;
            $data['cropName'] = $cropData;
            $data['productName'] = $productData;

            array_push($fmDetails, $data);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $fmDetails,
        ]);
    }
    public function postFMData(Request $request)
    {
        // dd($request->fmID);
        if ($request->action == 2) {
            $result = FarmerMeeting::where('fmId', $request->fmID)->update(['approvstatus' => 2]);
        } else {
            $result = FarmerMeeting::where('fmId', $request->fmID)->update([
                'approvstatus' => 1,
                'auth_remark' => $request->ac,
                'Aprove_Date' => date('Y-m-d'),
            ]);
        }

        return response()->json([
            'code' => 200,
            'success' => $result,
        ]);
    }
    public function getDealerProfileJunkReprt(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $endDate = $request->end_date;

        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();

        // dd($dayStartData);
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $regionId = $region->category_id;
                $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionId);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

                $empSql1 = "SELECT count(*) AS totalCount,sum(agencyTurnover) AS agencyTurnoverCount,sum(agencyGAPLTurnover) AS agencyGAPLTurnoverCount FROM `tbl_agency` LEFT JOIN `tbl_agencydetail` ON `tbl_agency`.`agencyId` = `tbl_agencydetail`.`agencyId` WHERE  `tbl_agency`.`agencyRegion` IN ($getAllRegionIDs) AND `tbl_agency`.`agencyType` = 1 AND `tbl_agencydetail`.`date` BETWEEN '$fromDate' AND '$toDate'  ";
                $result = DB::select($empSql1);

                $empSql2 = "SELECT count(*) AS dtotalCount,sum(agencyTurnover) AS dagencyTurnoverCount,sum(agencyGAPLTurnover) AS dagencyGAPLTurnoverCount FROM `tbl_agency` LEFT JOIN `tbl_agencydetail` ON `tbl_agency`.`agencyId` = `tbl_agencydetail`.`agencyId` WHERE  `tbl_agency`.`agencyRegion` IN ($getAllRegionIDs) AND `tbl_agency`.`agencyType` = 2 AND `tbl_agencydetail`.`date` BETWEEN '$fromDate' AND '$toDate'  ";
                $result1 = DB::select($empSql2);

                $data['region_name'] = $region->category_name . '-' . $regionId;
                $data['dealer_count'] = $result[0]->totalCount;
                $data['agencyTurnoverCount'] = round($result[0]->agencyTurnoverCount, 2);
                $data['agencyGAPLTurnoverCount'] = round($result[0]->agencyGAPLTurnoverCount, 2);
                $data['dtotalCount'] = $result1[0]->dtotalCount;
                $data['dagencyTurnoverCount'] = round($result1[0]->dagencyTurnoverCount, 2);
                $data['dagencyGAPLTurnoverCount'] = round($result1[0]->dagencyGAPLTurnoverCount, 2);
                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();
            foreach ($getEmployee as $employee) {
                $empIDs = $employee->id;
                $dayStartData = DayStart::selectRaw('COUNT(*) as count, date')
                    ->where('uid', $empIDs)
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->groupBy('date', 'date')
                    ->get()
                    ->pluck('count', 'date')
                    ->toArray();
                $data['region_name'] = $employee->emp_name;
                for ($i = 1; $i <= $endDate; $i++) {
                    $str = '0' . $i;
                    $day = strlen($str) > 2 ? substr($str, 1) : $str;
                    $newDate = date('Y', strtotime($fromDate)) . '-' . date('m', strtotime($fromDate)) . '-' . $day;
                    $data[$i] = array_key_exists($newDate, $dayStartData) ? 'P' : 'A';
                }
                array_push($reportArray, $data);
            }
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getICCountReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $endDate = $request->end_date;

        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();

        // dd($dayStartData);
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $regionId = $region->category_id;
                $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionId);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $request['regionIds'] = $getAllRegionIDs;
                $request['from_date'] = $fromDate;
                $request['to_date'] = $toDate;

                $data['region_name'] = $region->category_name . '-' . $region->category_id;
                $data['ic_count'] = $this->getRegionIcCount($request)->getData()->getRegionIcCount;

                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();
            foreach ($getEmployee as $employee) {
                $empIDs = $employee->id;
                $dayStartData = DayStart::selectRaw('COUNT(*) as count, date')
                    ->where('uid', $empIDs)
                    ->whereBetween('date', [$fromDate, $toDate])
                    ->groupBy('date', 'date')
                    ->get()
                    ->pluck('count', 'date')
                    ->toArray();
                $data['region_name'] = $employee->emp_name;
                for ($i = 1; $i <= $endDate; $i++) {
                    $str = '0' . $i;
                    $day = strlen($str) > 2 ? substr($str, 1) : $str;
                    $newDate = date('Y', strtotime($fromDate)) . '-' . date('m', strtotime($fromDate)) . '-' . $day;
                    $data[$i] = array_key_exists($newDate, $dayStartData) ? 'P' : 'A';
                }
                array_push($reportArray, $data);
            }
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getLoginReport(Request $request)
    {
        $regionID = $request->regionID;
        $date = $request->date;
        $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $getEmployeeDetails = DB::table('tbl_employee as e')
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid');
                $join->where('tds.date', '=', $date);
            })
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->select('e.emp_name', 'e.emp_mobile', 'e.state', 'td.designationName', 'tds.stime', 'tds.date', 'tc.category_name')
            ->whereIn('e.region', explode(',', $getAllRegionIDs))
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'report_data' => $getEmployeeDetails,
        ]);
    }
    public function getNotLoginReport(Request $request)
    {
        $regionID = $request->regionID;
        $date = $request->date;
        
        // Use the getRegionId function to get region IDs
        $getAllRegionIDs = $this->getRegionId($regionID);
        
        // Get total employees in the specified regions
        $totalEmployees = Employee::whereIn('region', explode(',', $getAllRegionIDs))->count();
        
        // Get login details for employees on the specified date
        $getLoginEmployeeDetails = DB::table('tbl_daystart as tds')
            ->leftJoin('tbl_employee as e', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid');
                $join->where('tds.date', '=', $date);
            })
            ->select('e.id')
            ->whereIn('e.region', explode(',', $getAllRegionIDs))
            ->get()
            ->pluck('id'); 
        
        // Get employee details based on the login details
        $getEmployeeDetails = DB::table('tbl_employee as e')
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->leftJoin('tbl_category as tc', 'e.region', 'tc.category_id')
            ->leftJoin('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid');
                $join->where('tds.date', '=', $date);
            })
            ->select('e.emp_name', 'e.emp_mobile', 'e.state', 'td.designationName', 'tc.category_name')
            ->whereNotIn('e.id', $getLoginEmployeeDetails) 
            ->where('e.user_role','!=' ,'admin') 
            ->where('e.deleteFlag', 0);
        
        if ($request->empID) {
             $getEmployeeDetails->where('e.id', $request->empID);
        }
            
        // Get the total record count
        $totalCount = $getEmployeeDetails->count();
        
        if ($request->keyword) {
            
            $getEmployeeDetails = $getEmployeeDetails->Where(function ($query) use ($request) {
                $query->orWhere('e.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('e.emp_mobile', 'like', '%' . $request->keyword . '%');
            });
        }
        
        // Handle pagination
        if ($request->paginate == "true") {
            $getEmployeeDetails = $getEmployeeDetails->simplePaginate();
        } else {
            $getEmployeeDetails = $getEmployeeDetails->get()->toArray();
        }
        
        return response()->json([
            'code' => 200,
            'total_employees' => $totalCount,
            'report_data' => $getEmployeeDetails,
        ]);

    }
    public function findSDAndSDVProduct($type, $regionIDs, $product, $crop, $from, $to)
    {
        $getCount = DB::table('tbl_farmactivity as tfa');
        $getCount = $getCount->leftJoin('tbl_farmer as tf', 'tfa.farmerId', 'tf.farmerId')->select('tfa.faId');
        if (in_array('all', $crop) && !in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfa.productId', $product);
        } elseif (!in_array('all', $crop) && in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfa.cropId', $crop);
        } elseif (in_array('all', $crop) && in_array('all', $product)) {
        } else {
            $getCount = $getCount->whereIn('tfa.cropId', $crop);
            $getCount = $getCount->whereIn('tfa.productId', $product);
        }
        $getCount = $getCount
            ->whereBetween($type, [$from, $to])
            ->whereIn('tf.farmerRegion', explode(',', $regionIDs))
            ->get()
            ->count();
        return $getCount;
    }
    public function findProduct_fd($regionIDs, $product, $crop, $from, $to)
    {
        $getCount = DB::table('tbl_farmactivityFD as tfd');
        $getCount = $getCount->leftJoin('tbl_farmer as tf', 'tfd.farmerId', 'tf.farmerId')->select('tfd.fafdId');
        if (in_array('all', $crop) && !in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfd.productId', $product);
        } elseif (!in_array('all', $crop) && in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfd.cropId', $crop);
        } elseif (in_array('all', $crop) && in_array('all', $product)) {
        } else {
            $getCount = $getCount->whereIn('tfd.cropId', $crop);
            $getCount = $getCount->whereIn('tfd.productId', $product);
        }
        $getCount = $getCount
            ->whereBetween('tfd.FD_date', [$from, $to])
            ->whereIn('tf.farmerRegion', explode(',', $regionIDs))
            ->get()
            ->count();
        return $getCount;
    }
    public function findProduct_fm($regionIDs, $product, $crop, $from, $to)
    {
        $getCount = DB::table('tbl_farmermeeting as tfm');
        $getCount = $getCount->select('tfm.fmId');
        if (in_array('all', $crop) && !in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfm.fmProductIds', $product);
        } elseif (!in_array('all', $crop) && in_array('all', $product)) {
            $getCount = $getCount->whereIn('tfm.cropId', $crop);
        } elseif (in_array('all', $crop) && in_array('all', $product)) {
        } else {
            $getCount = $getCount->whereIn('tfm.cropId', $crop);
            $getCount = $getCount->whereIn('tfm.fmProductIds', $product);
        }
        $getCount = $getCount
            ->whereBetween('tfm.fmDate', [$from, $to])
            ->whereIn('tfm.farmerRegion', explode(',', $regionIDs))
            ->get()
            ->count();
        return $getCount;
    }
    public function getAllProducts(Request $request)
    {
        $getAllProducts = DB::table('tbl_product')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'all_products' => $getAllProducts,
        ]);
    }
    public function getAllActivityProducts(Request $request)
    {
        $getAllActivityProducts = DB::table('tbl_activity_product')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'all_products' => $getAllActivityProducts,
        ]);
    }
    public function getAllCrops(Request $request)
    {
        $getAllCrops = DB::table('tbl_crop')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'all_crops' => $getAllCrops,
        ]);
    }
    
    public function getFieldActivityReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $productIDs = $request->productIds;
        $cropIDs = $request->cropIds;
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->get()
            ->toArray();
        // dd($getRegion);
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $categoryID = $region->category_id;
                $categoryIDWithParent = $categoryID . ',' . $this->getRegionId($categoryID);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $data['region_name'] = $region->category_name . '-' . $categoryID;
                $data['sd_count'] = $this->findSDAndSDVProduct('SD_date', $getAllRegionIDs, $productIDs, $cropIDs, $fromDate, $toDate);
                $data['sdv_count'] = $this->findSDAndSDVProduct('SDV_date', $getAllRegionIDs, $productIDs, $cropIDs, $fromDate, $toDate);
                $data['fd_count'] = $this->findProduct_fd($getAllRegionIDs, $productIDs, $cropIDs, $fromDate, $toDate);
                $data['fm_count'] = $this->findProduct_fm($getAllRegionIDs, $productIDs, $cropIDs, $fromDate, $toDate);

                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            $getEmployee = DB::table('tbl_employee')
                ->where('deleteFlag', 0)
                ->where('region', $regionID)
                ->get()
                ->toArray();
            foreach ($getEmployee as $employee) {
                $getAllCountData = DB::table('tbl_emp_activity_count')
                    ->selectRaw(
                        'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
                    )
                    ->whereBetween('activityDate', [$fromDate, $toDate])
                    ->where('empId', $employee->id)
                    ->get()
                    ->toArray();

                $data['region_name'] = $employee->emp_name;
                $data['sd_count'] = $getAllCountData[0]->sd_count ? $getAllCountData[0]->sd_count : 0;
                $data['sdv_count'] = $getAllCountData[0]->sdv_count ? $getAllCountData[0]->sdv_count : 0;
                $data['fd_count'] = $getAllCountData[0]->fd_count ? $getAllCountData[0]->fd_count : 0;
                $data['fm_count'] = $getAllCountData[0]->fm_count ? $getAllCountData[0]->fm_count : 0;
                array_push($reportArray, $data);
            }
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getSDDetailReport(Request $request)
    {
        // dd($request->all());
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;
        $productIDs = $request->productIds;
        $cropIDs = $request->cropIds;

        $result = DB::table('tbl_farmactivity as tfa');
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.SD_date', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.cropName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.productName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result
            ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tfa.empId', '=', 'te.id')
            ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
            ->leftJoin('tbl_activity_product as tp', 'tfa.productId', '=', 'tp.pid')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->where('tfa.SD_Flag', 1)
            ->where('te.deleteFlag', false)
            ->orderBy('tfa.faId', 'desc');
        if ($request->paginate == "true") { 
            $result = $result->select(
                'tfa.SD_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                'te.emp_name',
                'tc.cropName',
                'tp.productName',
                'tcc.category_name',
                'tfa.SD_Area',
                'tfa.SD_ProductQty',
                'tfa.sd_latlong',
                'tfa.SD_photo'
            );
        } else {
            $result = $result->select(
                'tfa.SD_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                'te.emp_name',
                'tc.cropName',
                'tp.productName',
                'tcc.category_name',
                'tfa.SD_Area',
                'tfa.SD_ProductQty',
                'tfa.sd_latlong',
                'tfa.SD_photo'
            );
        }
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.SD_date', [$fromDate, $toDate]);
        }
        if ($request->empID) {
            $result = $result->where('tfa.empId', $request->empID);
        }else{
            $getAllRegionIDs = $this->getRegionId($regionID);
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }
        if ($request->productIds) {
            $result = $result->where('tfa.productId', $request->productIds);
        }
        if ($request->cropIds) {
            $result = $result->where('tfa.cropId', $request->cropIds);
        }
        
        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    public function getSDVDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;
        $productIDs = $request->productIds;
        $cropIDs = $request->cropIds;
        $result = DB::table('tbl_farmactivity as tfa');
        $result = $result->where('tfa.SDV_Flag', 1);
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfa.SDV_date', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.cropName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.productName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result
            ->leftJoin('tbl_farmer as tf', 'tfa.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tfa.empId', '=', 'te.id')
            ->leftJoin('tbl_crop as tc', 'tfa.cropId', '=', 'tc.cropId')
            ->leftJoin('tbl_activity_product as tp', 'tfa.productId', '=', 'tp.pid')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->orderBy('tfa.faId', 'desc');
        if ($request->paginate == "true") {
            $result = $result->select(
                'tfa.SDV_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                'te.emp_name',
                'tc.cropName',
                'tp.productName',
                'tcc.category_name',
                'tfa.SD_Area',
                'tfa.SD_ProductQty',
                'tfa.sdv_latlong',
                'tfa.SDV_photo',
                'tfa.SDV_farmerNumber'
            );
        } else {
            $result = $result->select('tfa.SDV_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                'te.emp_name',
                'tc.cropName',
                'tp.productName',
                'tcc.category_name',
                'tfa.SD_Area',
                'tfa.SD_ProductQty',
                'tfa.sdv_latlong',
                'tfa.SDV_photo',
                'tfa.SDV_farmerNumber'
            );
        }
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfa.SDV_date', [$fromDate, $toDate]);
        }
        
        if ($request->empID) {
            $result = $result->where('tfa.empId', $request->empID);
        }else{
            $getAllRegionIDs = $this->getRegionId($regionID);
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }
        
        if ($request->productIds) {
            $result = $result->where('tfa.productId', $request->productIds);
        }
        if ($request->cropIds) {
            $result = $result->where('tfa.cropId', $request->cropIds);
        }

        
        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    public function getFMDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $empID = $request->empID;
        if ($empID) {
            $type = 'employee';
            $result = DB::table('tbl_farmermeeting as tfm');
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.fmDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.fmNos', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.fmRemark', 'like', '%' . $request->keyword . '%');
            });
            $result = $result
                ->leftJoin('tbl_employee as te', 'tfm.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tfm.farmerRegion')
                ->select('tfm.fmDate', 'tfm.villageNameID', 'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'te.emp_name', 'tcc.category_name')
                ->where('tfm.empId', $empID)
                ->whereBetween('tfm.fmDate', [$fromDate, $toDate]);
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        } else {
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $type = 'All';
            $result = DB::table('tbl_farmermeeting as tfm');
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.fmDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
            $result = $result
                ->leftJoin('tbl_employee as te', 'tfm.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tfm.farmerRegion')
                ->select('tfm.fmDate', 'tfm.villageNameID', 'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'te.emp_name', 'tcc.category_name')
                ->whereBetween('tfm.fmDate', [$fromDate, $toDate])
                ->whereIn('tfm.farmerRegion', explode(',', $getAllRegionIDs));
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        }
        $reportArray = [];
        $getProductData = DB::table('tbl_activity_product')
            ->get()
            ->pluck('productName', 'pid')
            ->toArray();
        $getCropData = DB::table('tbl_crop')
            ->get()
            ->pluck('cropName', 'cropId')
            ->toArray();
        foreach ($result as $value) {
            $data['fmDate'] = $value->fmDate;
            $data['villageNameID'] = $value->villageNameID;
            $data['fmNos'] = $value->fmNos;
            $data['fmRemark'] = $value->fmRemark;
            $data['emp_name'] = $value->emp_name;
            $data['category_name'] = $value->category_name;

            $allProduct = '';
            foreach (explode('#', $value->fmProductIds) as $product) {
                $allProduct .= $getProductData[$product] . ',';
            }
            $allCrop = '';
            if ($value->fmCropIds) {
                foreach (explode('#', $value->fmCropIds) as $crop) {
                    $allCrop .= $getCropData[$crop] . ',';
                }
            }
            $data['all_products'] = rtrim($allProduct, ',');
            $data['all_crops'] = $allCrop !== '' ? rtrim($allCrop, ',') : '';

            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200, 
            'report_data' => $result,
            'data' => $reportArray,
            'type' => $type,
        ]);
    }
    public function getFMReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;
        $meetingtype = $request->meetingtype;

        $result = DB::table('tbl_farmermeeting as tfm')
            ->leftJoin('tbl_employee as te', 'tfm.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tfm.farmerRegion')
            ->leftJoin('tbl_activity_product as tp', 'tp.pid', '=', 'tfm.fmProductIds')
            ->leftJoin('tbl_crop as tc', 'tc.cropId', '=', 'tfm.fmCropIds')
            ->leftJoin('tbl_meeting as tm', 'tm.meeting_id', '=', 'tfm.fmType')
            ->where(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfm.fmDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            })
            ->whereIn('tfm.approvstatus', [1, 3]) // Filter by approval statuses 1 and 3
            ->orderBy('tfm.fmId', 'desc');

        if ($request->timeFrameValue != "0") {
            $result->whereBetween('tfm.fmDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result->where('tfm.empId', $request->empID);
        }else{
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result->whereIn('tfm.farmerRegion', explode(',', $getAllRegionIDs));
        }

        if ($request->meetingtype) {
            $result->where('tfm.fmCatType', $request->meetingtype);
        }

        if ($request->paginate == "true") {
            $result = $result
                ->select('tfm.fmDate', DB::raw('CONVERT(CAST(CONVERT(tfm.villageNameID USING latin1) AS BINARY) USING utf8mb4) as villageNameID'),  'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'tfm.fmPhoto', 'te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName', 'tm.typeid')
                ->paginate();
        } else {
            $result = $result
                ->select('tfm.fmDate', DB::raw('CONVERT(CAST(CONVERT(tfm.villageNameID USING latin1) AS BINARY) USING utf8mb4) as villageNameID'),  'tfm.fmNos', 'tfm.fmRemark', 'tfm.fmCropIds', 'tfm.fmProductIds', 'tfm.fmPhoto', 'te.emp_name', 'tcc.category_name', 'tp.productName', 'tc.cropName', 'tm.typeid')
                ->get()
                ->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }

    public function getdeactivatedFDDetail(Request $request)
    {
        $result = DB::table('tbl_farmactivityFD as tfd');
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_date', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result
            ->leftJoin('tbl_farmer as tf', 'tfd.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tfd.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->where('te.deleteFlag', false);
        if ($request->paginate == "true") {
            $result = $result->select('tfd.FD_date', 'tf.farmerName', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name');
        } else {
            $result = $result->select('tfd.*', 'tf.*', 'te.*');
        }
        $result = $result->where('tfd.approvstatus', 0);
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfd.date', [$fromDate, $toDate]);
        }
        if ($request->empID) {
            $result = $result->where('tfd.empId', $request->empID);
        }
        // ->where('ta.agencyId', 59084);
        if ($request->paginate == "true") {
            $result = $result->simplePaginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'message' => "FD fetched successfully",
            'data' => $result,
        ]);
    }

    public function getFDDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;
        $productIDs = $request->productIds;
        $cropIDs = $request->cropIds;

        $result = DB::table('tbl_farmactivityFD as tfd')
            ->leftJoin('tbl_farmer as tf', 'tfd.farmerId', '=', 'tf.farmerId')
            ->leftJoin('tbl_employee as te', 'tfd.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->leftJoin('tbl_crop as tc', 'tfd.cropId', '=', 'tc.cropId')
            ->leftJoin('tbl_activity_product as tp', 'tfd.productId', '=', 'tp.pid')
            ->orderBy('tfd.fafdId', 'desc');
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_date', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.cropName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tp.productName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_Area', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_ProductQty', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.FD_result', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.Actual_Farmerno', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tfd.Actual_Budget', 'like', '%' . $request->keyword . '%');
            });
        }

        if ($request->paginate == "true") {
            $result = $result->select(
                'tfd.FD_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile', 
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'),
                'te.emp_name',
                'tcc.category_name',
                'tc.cropName',
                'tp.productName',
                'tfd.FD_Area',
                'tfd.FD_ProductQty',
                'tfd.FD_result',
                'tfd.Actual_Farmerno',
                'tfd.Actual_Budget',
                'tfd.fd_latlong',
                'tfd.fd_image',
                'tfd.remark',
                'tfd.fd_latlong'
            );
        } else {
            $result = $result->select(
                'tfd.FD_date',
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                'tf.farmerMobile', 
                 DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'),
                'te.emp_name',
                'tcc.category_name',
                'tc.cropName',
                'tp.productName',
                'tfd.FD_Area',
                'tfd.FD_ProductQty',
                'tfd.FD_result',
                'tfd.Actual_Farmerno',
                'tfd.Actual_Budget',
                'tfd.fd_latlong',
                'tfd.fd_image',
                'tfd.remark',
                'tfd.fd_latlong'
            );
        }

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tfd.FD_date', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tfd.empId', $request->empID);
        }else{
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }

        if ($request->productIds) {
            $result = $result->where('tfd.productId', $request->productIds);
        }

        if ($request->cropIds) {
            $result = $result->where('tfd.cropId', $request->cropIds);
        }

        
        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }

    public function getICDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $empID = $request->empID;
        if ($empID) {
            $type = 'employee';
            $result = DB::table('tbl_farmer as tf');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerRegDate', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                ->select('tf.farmerId', 'tf.farmerRegDate', 'tf.farmerLandAcerage', 'tf.farmerName', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name')
                ->where('tf.empId', $empID)
                ->whereBetween('tf.farmerRegDate', [$fromDate, $toDate])
                ->orderBy('tf.farmerId', 'ASC');
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        } else {
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $revisitData = DB::table('tbl_revisit')
                ->selectRaw('count(farmerId) as totalCount, farmerId')
                ->whereBetween('revisit_datetime', [$fromDate . ' ' . '00:00:00', $toDate . ' ' . '23:59:59'])
                ->groupBy('farmerId')
                ->get()
                ->pluck('totalCount', 'farmerId')
                ->toArray();
            $type = 'All';
            $result = DB::table('tbl_farmer as tf');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerRegDate', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                ->select('tf.farmerId', 'tf.farmerRegDate', 'tf.farmerName', 'tf.farmerLandAcerage', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name')
                ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                ->whereBetween('tf.farmerRegDate', [$fromDate, $toDate])
                ->orderBy('tf.farmerId', 'ASC');
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'type' => $type,
            'revisit_data' => $revisitData,
        ]);
    }
    public function getICReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;

        $result = DB::table('tbl_farmer as tf');

        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerRegDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }

        $result = $result
            ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tf.agencyId')
            ->leftJoin('tbl_crop as tcr1', 'tf.farmerRabiCrop1', '=', 'tcr1.cropId')
            ->leftJoin('tbl_crop as tcr2', 'tf.farmerRabiCrop2', '=', 'tcr2.cropId')
            ->leftJoin('tbl_crop as tck1', 'tf.farmerKharifCrop1', '=', 'tck1.cropId')
            ->leftJoin('tbl_crop as tck2', 'tf.farmerKharifCrop2', '=', 'tck2.cropId')
            ->leftJoin('tbl_farmerBuyingPattern as tfbp', 'tf.farmerBuyingPattern', '=', 'tfbp.id')
            ->leftJoin('tbl_farmer_type as tft', 'tf.farmerType', '=', 'tft.id')
            ->orderBy('tf.farmerId', 'desc');

        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tf.farmerRegDate', [$fromDate, $toDate]);
        }

        if ($request->empID) {
            $result = $result->where('tf.empId', $request->empID);
        }else {
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }
        
        if ($request->verifiedStatus) {
            $result = $result->where('tf.verifiedFlag', $request->verifiedStatus);
        }
        
        if ($request->farmerType) {
            $result = $result->where('tf.farmerType', $request->farmerType);
        }
        
        if ($request->farmerBuyingPattern) {
            $result = $result->where('tf.farmerBuyingPattern', $request->farmerBuyingPattern);
        }
        
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result
                ->select(
                    'tf.farmerId',
                    'tf.farmerRegDate',
                    'tf.farmerLandAcerage',
                    'tf.farmerName',
                    'tf.farmerMobile',
                    'tf.farmerAddress',
                    'te.emp_name',
                    'tcc.category_name',
                    'tf.farmerWaterDependency',
                    'tf.farmerSourceOfIrrigation',
                    'tf.farmerLandAcerage',
                    'tc.agencyShopName',
                    'tcr1.cropName as farmerRabiCrop1',
                    'tcr2.cropName as farmerRabiCrop2',
                    'tck1.cropName as farmerKharifCrop1',
                    'tck2.cropName as farmerKharifCrop2',
                    'tfbp.patternName as patternName',
                    'tft.typeName as typeName'
                )
                ->paginate();
        } else {
            $result = $result
                // ->select('tf.*', 'te.*', 'tcc.*','tc.agencyShopName')
                ->select(
                    'tf.farmerId',
                    'tf.farmerRegDate',
                    'tf.farmerLandAcerage',
                    'tf.farmerName',
                    'tf.farmerMobile',
                    'tf.farmerAddress',
                    'te.emp_name',
                    'tcc.category_name',
                    'tf.farmerWaterDependency',
                    'tf.farmerSourceOfIrrigation',
                    'tf.farmerLandAcerage',
                    'tc.agencyShopName',
                    'tcr1.cropName as farmerRabiCrop1',
                    'tcr2.cropName as farmerRabiCrop2',
                    'tck1.cropName as farmerKharifCrop1',
                    'tck2.cropName as farmerKharifCrop2',
                    'tfbp.patternName as patternName',
                    'tft.typeName as typeName'
                )
                ->get()
                ->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'total_records' => $totalCount,
        ]);
    }
    
    public function getICUpdatedReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;
    
        $result = DB::table('tbl_farmer as tf');
    
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerRegDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
            });
        }
    
        $result = $result
            ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tf.agencyId')
            ->leftJoin('tbl_farmerBuyingPattern as tfbp', 'tf.farmerBuyingPattern', '=', 'tfbp.id')
            ->leftJoin('tbl_farmer_type as tft', 'tf.farmerType', '=', 'tft.id')
            ->orderBy('tf.farmerId', 'desc');
    
        if ($request->timeFrameValue != "0") {
            $result = $result->whereBetween('tf.farmerRegDate', [$fromDate, $toDate]);
        }
    
        if ($request->empID) {
            $result = $result->where('tf.empId', $request->empID);
        } else {
            $getAllRegionIDs = $this->getRegionId($request->regionID);
            $result = $result->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
        }
    
        if ($request->verifiedStatus) {
            $result = $result->where('tf.verifiedFlag', $request->verifiedStatus);
        }
    
        if ($request->farmerType) {
            $result = $result->where('tf.farmerType', $request->farmerType);
        }
    
        if ($request->farmerBuyingPattern) {
            $result = $result->where('tf.farmerBuyingPattern', $request->farmerBuyingPattern);
        }
    
        $totalCount = $result->count();
    
        if ($request->paginate == "true") {
            $result = $result
                ->select(
                    'tf.farmerId', 'tf.farmerLatLong','tf.farmerPincode','tf.farmerType', 'tf.farmerBuyingPattern', 'tf.whatsUpFlag', 'tf.verifiedFlag',
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                    'tf.farmerMobile','tf.farmerAltNumber', 'tf.farmerLocation', 'tf.farmerPincode', 'tf.farmerRegion', 'tf.farmerWaterDependency', 'tf.farmerSourceOfIrrigation', 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity'), 
                    'tf.farmerLandAcerage', 'tf.farmerCrop', 'tf.farmerAcreage', 'tf.farmerRegDate', 'tf.activity_time', 
                    'te.emp_name',
                    'tcc.category_name',
                     DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                    'tfbp.patternName as patternName',
                    'tft.typeName as typeName'
                )
                ->paginate(15);
                $paginate = $result->toArray();
                unset($paginate['data']);
        } else {
            $result = $result
                ->select(
                    'tf.farmerId', 'tf.farmerLatLong','tf.farmerPincode','tf.farmerType', 'tf.farmerBuyingPattern', 'tf.whatsUpFlag', 'tf.verifiedFlag',
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                    'tf.farmerMobile','tf.farmerAltNumber', 'tf.farmerLocation', 'tf.farmerPincode', 'tf.farmerRegion', 'tf.farmerWaterDependency', 'tf.farmerSourceOfIrrigation', 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity'), 
                    'tf.farmerLandAcerage', 'tf.farmerCrop', 'tf.farmerAcreage', 'tf.farmerRegDate', 'tf.activity_time', 
                    'te.emp_name',
                    'tcc.category_name',
                    'tc.agencyShopName',
                     DB::raw("CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),
                    'tfbp.patternName as patternName',
                    'tft.typeName as typeName'
                )
                ->get();
            $paginate = [];
        }
    
        $cropValArry = $this->getAllCropsList();
        $data = [];
    
        if (count($result) > 0) {
            foreach ($result as $item) {
                $farmerCropNameArray = [];
                
                $farmerAcreageArray = ($item->farmerAcreage) ? explode('#', $item->farmerAcreage) : [];
    
                if ($item->farmerCrop) {
                    $farmerCropArray = explode('#', $item->farmerCrop);
                    foreach ($farmerCropArray as $crop) {
                        $key = array_search($crop, array_column($cropValArry, 'cropId'));
                        if ($key !== false) {
                            $farmerCropNameArray[] = $cropValArry[$key]['cropName'];
                        }
                    }
                }
    
                $data[] = [
                    'farmerId' => $item->farmerId,
                    'farmerName' => $item->farmerName,
                    'farmerMobile' => $item->farmerMobile,
                    'farmerAltNumber' => $item->farmerAltNumber,
                    'farmerLocation' => $item->farmerLocation,
                    'farmerAddress' => $item->farmerLocation,
                    'farmerCity' => $item->farmerCity,
                    'farmerPincode' => $item->farmerPincode,
                    'category_name' => $item->category_name,
                    'farmerWaterDependency' => $item->farmerWaterDependency,
                    'farmerSourceOfIrrigation' => $item->farmerSourceOfIrrigation,
                    'farmerLandAcerage' => $item->farmerLandAcerage,
                    'farmerCrop' => $farmerCropNameArray,
                    'farmerAcreage' => $farmerAcreageArray,
                    'agencyShopName' => $item->agencyShopName,
                    'farmerRegDate' => $item->farmerRegDate,
                    'activity_time' => $item->activity_time,
                    'emp_name' => $item->emp_name,
                    'farmerLatLong' => $item->farmerLatLong,
                    'patternName' => $item->patternName,
                    'typeName' => $item->typeName,
                    'whatsUpFlag' => $item->whatsUpFlag,
                    'verifiedFlag' => $item->verifiedFlag
                ];
            }
    
            return response()->json(['code' => 201, 'message' => 'Data fetch successfully', 'data' => $data, 'pagination' => $paginate]);
        } else {
            return response()->json(['code' => 201, 'message' => 'Data not available']);
        }
    }

    public function getAVDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $empID = $request->empID;
        if ($empID) {
            $type = 'employee';
            $result = DB::table('tbl_agencyvisit as tav');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tav.agencyType', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
                ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
                ->select('tav.agencyType', 'ta.agencyMobile', 'ta.agencyName', 'tav.visitDate', 'tav.cropUpdate', 'tav.liquidation', 'tav.feedback', 'tav.collecttion', 'tav.postHarvest', 'te.emp_name', 'tcc.category_name')
                ->where('tav.empId', $empID)
                ->whereBetween('tav.visitDate', [$fromDate, $toDate]);
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        } else {
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $type = 'All';
            $result = DB::table('tbl_agencyvisit as tav');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tav.agencyType', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
                ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
                ->select('tav.agencyType', 'ta.agencyMobile', 'ta.agencyName', 'tav.visitDate', 'tav.cropUpdate', 'tav.liquidation', 'tav.feedback', 'tav.collecttion', 'tav.postHarvest', 'te.emp_name', 'tcc.category_name')
                ->whereIn('tav.agencyRegion', explode(',', $getAllRegionIDs))
                ->whereBetween('tav.visitDate', [$fromDate, $toDate]);
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        }
        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'type' => $type,
        ]);
    }

    public function getAVReport(Request $request)
    {
        $regionID = $request->regionIndex;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;

        $result = DB::table('tbl_agencyvisit as tav')
            ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
            ->leftJoin('tbl_purpose_agencyvisit as to', 'to.purpose_agencyVisit_id', '=', 'tav.purpose')
            ->orderBy('tav.visitId', 'desc');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('te.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.agencyType', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
            });
        }

        if ($regionID) {
            $result = $result->where('tav.agencyRegion', $regionID);
        }

        if ($fromDate && $toDate) {
            $result = $result->whereBetween('tav.visitDate', [$fromDate, $toDate]);
        }

        if ($empID) {
            $result = $result->where('tav.empId', $empID);
        }

        // Calculate the total count before paginating
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select('tav.agencyType', 'ta.agencyMobile', 'ta.agencyShopName', 'tav.visitDate', 'tav.purpose', 'tav.remark', 'te.emp_name', 'tcc.category_name', 'tav.aVisitPhoto_key')->simplePaginate();
        } else {
            $result = $result
                ->select('ta.*', 'tcc.*', 'te.*', 'tav.*', 'tav.aVisitPhoto_key')
                ->get()
                ->toArray();
        }

        $array = DB::table('tbl_purpose_agencyvisit')
            ->get()
            ->pluck('purpose_agencyVisit_name', 'purpose_agencyVisit_id')
            ->toArray();

        return response()->json([
            'code' => 200,
            'message' => "Data fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include the total count in the response
            'allPurpose' => $array,
        ]);
    }
    
    // agency wise agency visit report
    public function getAgencyWiseAVReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $agencyId = $request->agencyIndex;

        $result = DB::table('tbl_agencyvisit as tav')
            ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
            ->leftJoin('tbl_purpose_agencyvisit as to', 'to.purpose_agencyVisit_id', '=', 'tav.purpose')
            ->orderBy('tav.visitId', 'desc');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('te.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.agencyType', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
            });
        }

        
        if ($fromDate && $toDate) {
            $result = $result->whereBetween('tav.visitDate', [$fromDate, $toDate]);
        }

        if ($agencyId) {
            $result = $result->where('tav.agencyId', $agencyId);
        }else{
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $result = $result->whereIn('tav.agencyRegion', explode(',', $categoryIDWithParent));
        }

        // Calculate the total count before paginating
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select('tav.agencyType','tav.agencyId', 'ta.agencyMobile',  DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'tav.visitDate', 'tav.purpose', 'tav.remark', 'te.emp_name', 'tcc.category_name', 'tav.aVisitPhoto_key','tav.activity_time')->simplePaginate();
        } else {
            $result = $result
                ->select('ta.*', 'tcc.*', 'te.*', 'tav.*', 'tav.aVisitPhoto_key','tav.activity_time as avActivityTime')
                ->get()
                ->toArray();
        }

        $array = DB::table('tbl_purpose_agencyvisit')
            ->get()
            ->pluck('purpose_agencyVisit_name', 'purpose_agencyVisit_id')
            ->toArray();

        return response()->json([
            'code' => 200,
            'message' => "Data fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include the total count in the response
            'allPurpose' => $array,
        ]);
    }
    
    // employee wise agency visit report
    public function getEmployeeWiseAVReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $empID = $request->empID;

        $result = DB::table('tbl_agencyvisit as tav')
            ->leftJoin('tbl_employee as te', 'tav.empId', '=', 'te.id')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
            ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tav.agencyRegion')
            ->leftJoin('tbl_purpose_agencyvisit as to', 'to.purpose_agencyVisit_id', '=', 'tav.purpose')
            ->orderBy('tav.visitId', 'desc');

        if ($request->keyword) {
            $result = $result->where(function ($query) use ($request) {
                $query
                    ->where('te.emp_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.agencyType', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyMobile', 'like', '%' . $request->keyword . '%')
                    ->orWhere('ta.agencyShopName', 'like', '%' . $request->keyword . '%')
                    ->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
            });
        }

        if ($fromDate && $toDate) {
            $result = $result->whereBetween('tav.visitDate', [$fromDate, $toDate]);
        }

        if ($empID) {
            $result = $result->where('tav.empId', $empID);
        }else{
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $result = $result->whereIn('tav.agencyRegion', explode(',', $categoryIDWithParent));
        }

        // Calculate the total count before paginating
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->select('tav.agencyType','tav.agencyId', 'ta.agencyMobile',  DB::raw("CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"), 'tav.visitDate', 'tav.purpose', 'tav.remark', 'te.emp_name', 'tcc.category_name', 'tav.aVisitPhoto_key','tav.activity_time')->simplePaginate();
        } else {
            $result = $result
                ->select('ta.*', 'tcc.*', 'te.*', 'tav.*', 'tav.aVisitPhoto_key','tav.activity_time as avActivityTime')
                ->get()
                ->toArray();
        }

        $array = DB::table('tbl_purpose_agencyvisit')
            ->get()
            ->pluck('purpose_agencyVisit_name', 'purpose_agencyVisit_id')
            ->toArray();

        return response()->json([
            'code' => 200,
            'message' => "Data fetched successfully",
            'data' => $result,
            'total_records' => $totalCount, // Include the total count in the response
            'allPurpose' => $array,
        ]);
    }

    public function getRevisitDetailReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $empID = $request->empID;
        if ($empID) {
            $type = 'employee';
            $result = DB::table('tbl_revisit as tr');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tr.revisitPurpose', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tr.revisit_datetime', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tr.empId', '=', 'te.id')
                ->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'tr.farmerId')
                ->select('tr.revisit_datetime', 'tf.farmerName', 'tf.farmerMobile', 'tr.revisitPurpose', 'te.emp_name')
                ->where('tr.empId', $empID)
                ->whereBetween('tr.revisit_datetime', [$fromDate . ' ' . '00:00:00', $toDate . ' ' . '23:59:59']);
            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        } else {
            $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
            $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
            $type = 'All';
            $result = DB::table('tbl_revisit as tr');
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tr.revisitPurpose', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tr.revisit_datetime', 'like', '%' . $request->keyword . '%');
                });
            }
            $result = $result
                ->leftJoin('tbl_employee as te', 'tr.empId', '=', 'te.id')
                ->leftJoin('tbl_farmer as tf', function ($join) use ($getAllRegionIDs) {
                    $join->on('tf.farmerId', '=', 'tr.farmerId');
                    $join->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs));
                })
                ->select('tr.revisit_datetime', 'tf.farmerName', 'tf.farmerMobile', 'tr.revisitPurpose', 'te.emp_name')
                ->whereBetween('tr.revisit_datetime', [$fromDate . ' ' . '00:00:00', $toDate . ' ' . '23:59:59']);

            if ($request->paginate == "true") {
                $result = $result->paginate();
            } else {
                $result = $result->get()->toArray();
            }
        }
        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'type' => $type,
        ]);
    }
    public function getCropUpdate(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $paginate = $request->paginate;
        $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $result = DB::table('tbl_cropupdate as tcu');
        if ($request->keyword) {
            $result = $result->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tc.cropName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tav.visitDate', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tcu.focusSegment', 'like', '%' . $request->keyword . '%');
            });
        }
        $result = $result
            ->leftJoin('tbl_agencyvisit as tav', function ($join) use ($getAllRegionIDs, $fromDate, $toDate) {
                $join->on('tcu.visitId', '=', 'tav.visitId');
            })
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
            ->leftJoin('tbl_crop as tc', 'tc.cropId', '=', 'tcu.cropId')
            ->select('ta.agencyName', 'tc.cropName', 'tcu.focusSegment', 'tcu.remark', 'tav.visitDate')
            ->whereIn('tav.agencyRegion', explode(',', $getAllRegionIDs))
            ->where('tav.visitDate', '!=', null)
            ->where('ta.agencyName', '!=', null)
            ->whereBetween('tav.visitDate', [$fromDate, $toDate]);
        if ($request->paginate == "true") {
            $result = $result->paginate();
        } else {
            $result = $result->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }
    public function getFeedback(Request $request)
    {
        $regionID = $request->regionIndex;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;

        $categoryIDWithParent = $regionID . ',' . $this->getRegionId($regionID);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $query = DB::table('tbl_feedback as tf')
            ->leftJoin('tbl_agencyvisit as tav', function ($join) use ($getAllRegionIDs, $fromDate, $toDate) {
                $join->on('tf.visitId', '=', 'tav.visitId');
                $join->whereIn('tav.agencyRegion', explode(',', $getAllRegionIDs));
                $join->whereBetween('tf.created_at', [$fromDate, $toDate]);
            })
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tav.agencyId')
            ->select('ta.agencyName', 'tav.visitDate', 'tf.fdphoto', 'tf.fdText', 'tf.created_at');

        if ($request->keyword) {
            $query->orWhere(function ($query) use ($request) {
                $query->orWhere('ta.agencyName', 'like', '%' . $request->keyword . '%');
                $query->orWhere('tf.fdText', 'like', '%' . $request->keyword . '%');
            });
        }

        if ($request->paginate == "true") {
            $result = $query->paginate();
        } else {
            $result = $query->get()->toArray();
        }

        return response()->json([
            'code' => 200,
            'report_data' => $result,
        ]);
    }

    public function getDealerStockReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $agencyType = $request->agencyType;

        $productData = DB::table('tbl_activity_product')
            ->where('liquidationList', 1)
            ->get()
            ->toArray();
        $getRegion = DB::table('tbl_category')
            ->where('parent_category_id', $regionID)
            ->where('category_name', '!=', '')
            ->orWhere('category_id', $regionID)
            ->where('category_id', '!=', 1)
            ->get()
            ->toArray();
        $reportArray = [];
        if (count($getRegion)) {
            $type = 'region';
            foreach ($getRegion as $region) {
                $categoryID = $region->category_id;
                $getEmployee = DB::table('tbl_employee')
                    ->where('deleteFlag', 0)
                    ->where('region', $categoryID)
                    ->get()
                    ->toArray();
                $categoryIDWithParent = $this->getRegionId($categoryID);
                $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
                $getAllCountData = DB::table('tbl_emp_activity_count')
                    ->selectRaw(
                        'sum(ic) as ic_count, sum(sd) as sd_count, sum(sdv) as sdv_count, sum(fd) as fd_count, sum(fm) as fm_count, sum(av) as av_count, sum(revisit) as revisit_count, sum(dealer_profile) as dealer_profile_count, sum(liquidation) as liquidation_count'
                    )
                    ->whereBetween('activityDate', [$fromDate, $toDate])
                    ->whereIn('regionId', explode(',', $getAllRegionIDs))
                    ->get()
                    ->toArray();

                foreach ($productData as $product) {
                    $result = DB::table('tbl_liquidation_detail_stock as ls')
                        ->selectRaw('MAX(`liId`) AS liId')
                        ->leftJoin('tbl_agency as ta', function ($join) use ($agencyType, $getAllRegionIDs) {
                            $join->on('ls.agencyId', '=', 'ta.agencyId');
                            $join->where('ta.agencyType', $agencyType);
                        })
                        ->whereIn('ls.agencyRegion', explode(',', $getAllRegionIDs))
                        ->where('ls.productId', $product->pid)
                        ->whereBetween('ls.visitDate', [$fromDate, $toDate])
                        ->groupBy('ls.agencyId')
                        ->get()
                        ->toArray();
                    // dd($result);
                    $liIDs = array_column($result, 'liId');

                    if (count($liIDs)) {
                        $getStockData = DB::table('tbl_liquidation_detail_stock')
                            ->selectRaw('COUNT(`liId`) agencyCount, SUM(`supply`) supply,SUM(`remaining`) remaining')
                            ->whereIn('liId', $liIDs)
                            ->get()
                            ->toArray();
                        $data[$product->pid]['productCatSupply'] = $getStockData[0]->supply;
                        $data[$product->pid]['productCatRemaining'] = $getStockData[0]->remaining;
                        $data[$product->pid]['productName'] = $product->productName;
                    } else {
                        $data[$product->pid]['productCatSupply'] = 0;
                        $data[$product->pid]['productCatRemaining'] = 0;
                        $data[$product->pid]['productName'] = $product->productName;
                    }
                }
                $data['region_name'] = $region->category_name . '-' . $categoryID;
                $data['employee_name'] = !count($getEmployee) ? '' : $getEmployee[0]->emp_name;

                array_push($reportArray, $data);
            }
        } else {
            $type = 'employee';
            // array_push($reportArray, $data);
        }

        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'productData' => $productData,
            'regionID' => $regionID,
        ]);
    }
    function getAllProductName($productId)
    {
        if ($productId == 'All') {
            $result = DB::table('tbl_product')
                ->where('liquidationList', 1)
                ->get()
                ->toArray();
        } else {
            $result = DB::table('tbl_product')
                ->whereIn('pid', explode(',', $productId))
                ->get()
                ->toArray();
        }
        $arr = [];
        foreach ($result as $product) {
            $arr[] = [
                'pid' => $product->pid,
                'productName' => $product->productName,
                'pidCat' => $product->productType,
            ];
        }
        return $arr;
    }
    function getliquidationDetail($regionIds, $productId, $fromDate, $toDate, $agencyType)
    {
        $queryr = "SELECT *, MAX(`liId`) AS liId FROM `tbl_liquidation_detail_stock` LEFT JOIN
                `tbl_agency` ON `tbl_liquidation_detail_stock`.`agencyId` = `tbl_agency`.`agencyId`
                WHERE `tbl_liquidation_detail_stock`.`agencyRegion` IN ($regionIds) AND `tbl_liquidation_detail_stock`.`productId` = '$productId'
                AND `tbl_liquidation_detail_stock`.`visitDate` BETWEEN '$fromDate' AND '$toDate' AND `tbl_agency`.`agencyType`='$agencyType'  GROUP BY
                `tbl_liquidation_detail_stock`.`agencyId`";
        $result = DB::select($queryr);
        $agencyVisitId = "";
        if (count($result)) {
            foreach ($result as $value) {
                $agencyVisitId .= $value->liId . ',';
            }
            $agencyVisitId = substr($agencyVisitId, 0, -1);
        }
        $getLiquidationIds = $agencyVisitId;
        $multipleDataArray = [];

        if ($getLiquidationIds) {
            $liqData = DB::table('tbl_liquidation_detail_stock')
                ->whereIn('liId', explode(',', $getLiquidationIds))
                ->get()
                ->toArray();
            foreach ($liqData as $value) {
                $dateArray['agencyId'] = $value->agencyId;
                $dateArray['visitDate'] = $value->visitDate;
                $dateArray['productId'] = $value->productId;
                $dateArray['supply'] = $value->supply;
                $dateArray['remaining'] = $value->remaining;
                // $dateArray['sold'] = $value['sold'];
                $dateArray['empId'] = $value->empId;

                array_push($multipleDataArray, $dateArray);
            }
        }
        return $multipleDataArray;
    }
    public function getStockExportReport(Request $request)
    {
        $regionID = $request->regionID;
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $agencyType = $request->agencyType;

        $productData = DB::table('tbl_product')
            ->where('liquidationList', 1)
            ->get()
            ->toArray();
        $allProducts = $this->getAllProductsName('All');
        $categoryIDWithParent = $this->getRegionId(6);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');
        $getEmployee = DB::table('tbl_employee')
            ->where('deleteFlag', 0)
            ->whereIn('region', explode(',', $getAllRegionIDs))
            ->get()
            ->pluck('emp_name', 'id')
            ->toArray();
        $getEmployeeDesignation = DB::table('tbl_employee')
            ->where('deleteFlag', 0)
            ->whereIn('region', explode(',', $getAllRegionIDs))
            ->get()
            ->pluck('empDesignation', 'id')
            ->toArray();
        $getAllDesignation = DB::table('tbl_designation')
            ->get()
            ->pluck('designationName', 'designationId')
            ->toArray();
        $getAllCategory = DB::table('tbl_category')
            ->get()
            ->pluck('category_name', 'category_id')
            ->toArray();
        $reportArray = [];

        $sql = "SELECT `tbl_agencyvisit`.`agencyId`,`tbl_agency`.`agencyRegion`,
             `tbl_agency`.`agencyShopName`, `tbl_agency`.`distributorCode`,
             `tbl_agencyvisit`.`empId` FROM `tbl_agencyvisit`
             LEFT JOIN `tbl_agency` ON `tbl_agencyvisit`.`agencyId` = `tbl_agency`.`agencyId`
             WHERE `tbl_agencyvisit`.`liquidation` = '1'
             AND `tbl_agencyvisit`.`visitDate` BETWEEN '$fromDate' AND '$toDate'
             AND `tbl_agencyvisit`.`agencyRegion` IN ($getAllRegionIDs)
             AND `tbl_agency`.`agencyType`='$agencyType'
             GROUP BY `tbl_agencyvisit`.`agencyId`";
        $agencyLiquidationData = DB::select($sql);
        $productData = DB::table('tbl_product')
            ->where('liquidationList', 1)
            ->get()
            ->toArray();
        foreach ($productData as $product) {
            // $pid = $product->pid;
            $pid = 23;
            $getliquidationDetail[] = $this->getliquidationDetail($getAllRegionIDs, $pid, $fromDate, $toDate, $agencyType);
        }
        foreach ($agencyLiquidationData as $value) {
            $data['agencyShopName'] = $value->agencyShopName;
            $data['region_name'] = $getAllCategory[$value->agencyRegion];
            $data['employee_name'] = array_key_exists($value->empId, $getEmployee) ? $getEmployee[$value->empId] : '';
            $data['designationName'] = array_key_exists($value->empId, $getEmployeeDesignation) ? $getAllDesignation[$getEmployeeDesignation[$value->empId]] : '';
            if ($agencyType == 2) {
                $data['distributorCode'] = $value->distributorCode;
            }
            foreach ($productData as $product) {
                $keyIdPid = array_search($product->pid, array_column($allProducts, 'pid'));
                if ($keyIdPid) {
                    if ($keyIdPid === 11) {
                        dd(array_column($allProducts, 'pid'));
                    }
                    $keyId = array_search($value->agencyId, array_column($getliquidationDetail[$keyIdPid], 'agencyId'));
                    if ($keyId) {
                        $data[$product->pid]['visitDate'] = $getliquidationDetail[$keyIdPid][$keyId]['visitDate'];
                        $data[$product->pid]['remaining'] = $getliquidationDetail[$keyIdPid][$keyId]['remaining'];
                    } else {
                        $data[$product->pid]['visitDate'] = '-';
                        $data[$product->pid]['remaining'] = 0;
                    }
                }
            }
            array_push($reportArray, $data);
        }
        dd($reportArray);

        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'regionID' => $regionID,
        ]);
    }
    public function ftp_file_put_contents($remote_file, $file_string)
    {
        $ftp_server = "ftp.ehotelmanagement.com";
        $ftp_user_name = "pranay@ehotelmanagement.com";
        $ftp_user_pass = "Smart@#pt01";
        // Create temporary file
        $local_file = fopen('php://temp', 'r+');
        fwrite($local_file, $file_string);
        rewind($local_file);

        // FTP connection
        $ftp_conn = ftp_connect($ftp_server);

        // FTP login
        @$login_result = ftp_login($ftp_conn, $ftp_user_name, $ftp_user_pass);
        ftp_pasv($ftp_conn, true);
        // FTP upload
        if ($login_result) {
            $upload_result = ftp_fput($ftp_conn, $remote_file, $local_file, FTP_ASCII);
        }

        // Error handling
        if (!$login_result or !$upload_result) {
            echo '<p>FTP error: The file could not be written to the FTP server.</p>';
        }

        // Close FTP connection
        ftp_close($ftp_conn);

        // Close file handle
        fclose($local_file);
    }

    public function writeIntoFTPServer($value = '')
    {
        $this->ftp_file_put_contents('my-file.txt', 'This text will be written to your text file via FTP.');
        dd('test');
        $ftp_server = "ftp.ehotelmanagement.com";
        $ftp_user_name = "pranay@ehotelmanagement.com";
        $ftp_user_pass = "Smart@#pt01";
        $file = public_path('robots.txt'); //tobe uploaded
        $remote_file = "/test-file/test.txt";

        // set up basic connection
        $conn_id = ftp_connect($ftp_server);

        // login with username and password
        try {
            $login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass);
            ftp_pasv($conn_id, true);
        } catch (\Exception $e) {
            dd($e->getMessage());
        }
        // upload a file
        if (ftp_put($conn_id, $remote_file, $file, FTP_ASCII)) {
            echo "successfully uploaded $file\n";
            exit();
        } else {
            echo "There was a problem while uploading $file\n";
            exit();
        }
        // close the connection
        ftp_close($conn_id);
    }
    public function getMaterial(Request $request)
    {
        try {
            $materialData = Material::select('*')->where('isDeleted', false);

            if ($request->keyword) {
                $materialData = $materialData->where(function ($query) use ($request) {
                    $query->orWhere('sku_code', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('sku_name', 'like', '%' . $request->keyword . '%');
                });
            }

            $materialData = $materialData->orderBy('created_at', 'desc');

            if ($request->paginate == "true") {
                $materialData = $materialData->simplePaginate();
            } else {
                $materialData = $materialData->get()->toArray();
            }

            return response()->json([
                'code' => 200,
                'data' => $materialData,
            ]);
        } catch (\Exception $e) {
            dd($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }

    // Product category
    public function submitProducttype(Request $request)
    {
        try {
            $Producttype = $request->id ? ProductType::find($request->id) : new ProductType();

            $Producttype->prodType = $request->prodType;

            $Producttype->save();

            return response()->json([
                'code' => 200,
                'message' => "Product type Save successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    public function getproducttype(Request $request)
    {
        try {
            $result = DB::table('tbl_product_type as tfm');

            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('tfm.prodType', 'like', '%' . $request->keyword . '%');
                });
            }

            $result = $result->where('isDeleted', false)->orderBy('id', 'desc');

            if ($request->paginate == "true") {
                $result = $result->select('tfm.*');
            } else {
                $result = $result->select('tfm.*');
            }

            // Get the total record count
            $totalCount = $result->count();

            // Handle pagination
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }

            return response()->json([
                'code' => 200,
                'message' => "Crop fetched successfully",
                'data' => $result,
                'total_records' => $totalCount, // Include total record count in the response
            ]);
        } catch (\Exception $e) {
            // In case of any exception, it's better to log the error for debugging purposes
            // Log::error($e);
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data",
            ]);
        }
    }

    public function deleteproducttype(Request $request)
    {
        try {
            $ProductType = ProductType::find($request->id);
            $ProductType->isDeleted = true;
            $ProductType->save();

            return response()->json([
                'code' => 200,
                'message' => "Product Type deleted successfully",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while deleting crop",
            ]);
        }
    }
    public function getproducttypeList()
    {
        $productttype = DB::table('tbl_product_type')
            ->get()
            ->toArray();
        return response()->json([
            'code' => 200,
            'productType' => $productttype,
        ]);
    }

    // employee 360 report
    public function getEmpOverallActivityCountReport(Request $request)
    {
        $regionID = $request->regionID;
        
        $getAllRegionIDs = $this->getRegionId($regionID);
        $reportArray = [];
        
        if ($request->timeFrameValue != "0") {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        }else{
            $fromDate = date('Y-m-d',strtotime('-10 days'));
            $toDate = date('Y-m-d');
        }

        $getAllCountData = DB::table('tbl_employee as te')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region')
            ->leftJoin('tbl_activity_count_current_year as tec', function ($join) use ($fromDate, $toDate) {
                $join->on('te.id', '=', 'tec.empId')
                     ->whereBetween('tec.activityDate', [$fromDate, $toDate]);
            })
            ->select(
                'te.id',
                'te.emp_name',
                'te.emp_mobile',
                'te.date_of_joining',
                'te.EDP_code',
                'te.deleteFlag',
                'tc.*',
                DB::raw('COALESCE(SUM(tec.ic), 0) AS ic_count'),
                DB::raw('COALESCE(SUM(tec.sd), 0) AS sd_count'),
                DB::raw('COALESCE(SUM(tec.sdv), 0) AS sdv_count'),
                DB::raw('COALESCE(SUM(tec.fd), 0) AS fd_count'),
                DB::raw('COALESCE(SUM(tec.fm), 0) AS fm_count'),
                DB::raw('COALESCE(SUM(tec.av), 0) AS av_count'),
                DB::raw('COALESCE(SUM(tec.revisit), 0) AS revisit_count'),
                DB::raw('COALESCE(SUM(tec.dealer_profile), 0) AS dealer_profile_count'),
                DB::raw('COALESCE(SUM(tec.liquidation), 0) AS liquidation_count')
            )
            ->where('te.user_role', 'employee')
            ->where('te.deleteFlag', 0);
            

        if ($request->keyword) {
            $getSearchedEmployee = explode(',', $request->keyword);
            $getAllCountData = $getAllCountData->where(function ($query) use ($getSearchedEmployee) {
                for ($i = 0; $i < count($getSearchedEmployee); $i++) {
                    // $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orwhere('emp_name', 'like', '%' . $getSearchedEmployee[$i] . '%');
                    $query->orwhere('emp_mobile', 'like', '%' . $getSearchedEmployee[$i] . '%');
                    $query->orwhere('category_name', 'like', '%' . $getSearchedEmployee[$i] . '%');
                    $query->orwhere('date_of_joining', 'like', '%' . $getSearchedEmployee[$i] . '%');
                    $query->orwhere('EDP_code', 'like', '%' . $getSearchedEmployee[$i] . '%');
                }
            });
        }
        if ($request->empID != '') {
            $getAllCountData = $getAllCountData->where('te.id', $request->empID);
        } else {
            $getAllCountData = $getAllCountData->whereIn('te.region', explode(',', $getAllRegionIDs));
        }
        $getAllCountData = $getAllCountData->groupBy('tec.empID');

        // Calculate the total count before paginating
        $totalCount = $getAllCountData->count();

        if ($request->paginate == "true") {
            $getAllCountData = $getAllCountData->simplePaginate();
        } else {
            $getAllCountData = $getAllCountData->get()->toArray();
        }

        $getRegionList = $this->getRegionList()->getData();
        $regionObject = $getRegionList->regionList;

        $getRegionNameVal = [];
        foreach ($regionObject as $object) {
            $getRegionNameVal[] = (array) $object;
        }

        // print_r($getEmployee);
        foreach ($getAllCountData as $employee) {
            //   dd($employee);
            $unitId = $employee->unit;
            $mainRegionId = $employee->region;
            $territoryId = $employee->territory;
            $headquarterId = $employee->headquarter;

            $unitName = '';
            if ($unitId) {
                $key = '';
                $key = array_search($unitId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $unitName = '';
                } else {
                    $unitName = $getRegionNameVal[$key]['category_name'];
                }
            }

            $territoryName = '';
            if ($territoryId) {
                $key = '';
                $key = array_search($territoryId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $territoryName = '';
                } else {
                    $territoryName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $headquarterName = '';
            if ($headquarterId) {
                $key = '';
                $key = array_search($headquarterId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $headquarterName = '';
                } else {
                    $headquarterName = $getRegionNameVal[$key]['category_name'];
                }
            }
            $mainRegionName = '';
            if ($mainRegionId) {
                $key = '';
                $key = array_search($mainRegionId, array_column($getRegionNameVal, 'category_id'));
                if ($key === false) {
                    $mainRegionName = '';
                } else {
                    $mainRegionName = $getRegionNameVal[$key]['category_name'];
                }
            }
            // $empId = $employee->empID;
            $data['unit'] = $unitName;
            $data['region'] = $mainRegionName;
            $data['territory'] = $territoryName;
            $data['headquarter'] = $headquarterName;
            $data['work_region'] = $employee->category_name;
            $data['employee_name'] = $employee->emp_name;
            $data['doj'] = $employee->date_of_joining;
            $data['status'] = $employee->deleteFlag == 0 ? 'Active' : 'Deactive';
            $data['edp_no'] = $employee->EDP_code;
            $data['ic_count'] = $employee->ic_count ? $employee->ic_count : 0;
            $data['sd_count'] = $employee->sd_count ? $employee->sd_count : 0;
            $data['sdv_count'] = $employee->sdv_count ? $employee->sdv_count : 0;
            $data['fd_count'] = $employee->fd_count ? $employee->fd_count : 0;
            $data['fm_count'] = $employee->fm_count ? $employee->fm_count : 0;
            $data['av_count'] = $employee->av_count ? $employee->av_count : 0;
            $data['revisit_count'] = $employee->revisit_count ? $employee->revisit_count : 0;
            $data['dealer_count'] = $employee->dealer_profile_count ? $employee->dealer_profile_count : 0;
            $data['liquidation_count'] = $employee->liquidation_count ? $employee->liquidation_count : 0;
            array_push($reportArray, $data);
        }
        return response()->json([
            'code' => 200,
            'report_data' => $reportArray,
            'total_records' => $totalCount, // Include the total count in the response
            'result' => $getAllCountData,
        ]);
    }

    // public function getEmpOverallActivityCountReport(Request $request)
    // {
    //     //   $regionID = $request->regionID;
    //     //   $fromDate = $request->from_date;
    //     //   $toDate = $request->to_date;
    //     $regionID = 1;
    //     $fromDate = '2023-01-01';
    //     $toDate = '2023-05-08';
    //     $empIDs = $this->getEmployeeId($regionID);
    //     $reportArray = [];

    //     $getAllCountData = DB::table('tbl_employee as te');
    //     $getAllCountData = $getAllCountData->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'te.region');

    //     $getAllCountData = $getAllCountData
    //         ->select( 'te.*','tc.*')
    //         ->where('deleteFlag', 0)
    //         ->where('empDesignation','!=', 24);
    //     if ($request->keyword) {
    //         $getAllCountData = $getAllCountData->where(function ($query) use ($getSearchedEmployee) {
    //             for ($i = 0; $i < count($getSearchedEmployee); $i++) {
    //                 $query->orwhere('emp_name', $getSearchedEmployee[$i]);
    //                 $query->orwhere('emp_mobile', $getSearchedEmployee[$i]);
    //                 $query->orwhere('category_name', $getSearchedEmployee[$i]);
    //                 $query->orwhere('date_of_joining', $getSearchedEmployee[$i]);
    //                 $query->orwhere('EDP_code', $getSearchedEmployee[$i]);
    //             }
    //         });
    //     }
    //     if ($request->paginate == "true") {
    //         $getAllCountData = $getAllCountData->simplePaginate();
    //     } else {
    //         $getAllCountData = $getAllCountData->get()->toArray();
    //     }

    //     $getRegionList = $this->getRegionList()->getData();
    //     $regionObject = $getRegionList->regionList;

    //     $getRegionNameVal = [];
    //     foreach ($regionObject as $object) {
    //         $getRegionNameVal[] = (array) $object;
    //     }

    //     // print_r($getEmployee);
    //     foreach ($getAllCountData as $employee) {
    //         //   dd($employee);
    //         $unitId = $employee->unit;
    //         $mainRegionId = $employee->region;
    //         $territoryId = $employee->territory;
    //         $headquarterId = $employee->headquarter;

    //         $unitName = '';
    //         if($unitId){
    //             $key = '';
    //             $key = array_search($unitId, array_column($getRegionNameVal, 'category_id'));
    //             if ($key === FALSE) {
    //                 $unitName = '';
    //             } else {
    //                 $unitName = $getRegionNameVal[$key]['category_name'];
    //             }
    //         }

    //         $territoryName = '';
    //         if($territoryId){
    //             $key = '';
    //             $key = array_search($territoryId, array_column($getRegionNameVal, 'category_id'));
    //             if ($key === FALSE) {
    //                 $territoryName = '';
    //             } else {
    //                 $territoryName = $getRegionNameVal[$key]['category_name'];
    //             }
    //         }
    //         $headquarterName = '';
    //         if($headquarterId){
    //             $key = '';
    //             $key = array_search($headquarterId, array_column($getRegionNameVal, 'category_id'));
    //             if ($key === FALSE) {
    //                 $headquarterName = '';
    //             } else {
    //                 $headquarterName = $getRegionNameVal[$key]['category_name'];
    //             }
    //         }
    //         $mainRegionName = '';
    //         if($mainRegionId){
    //             $key = '';
    //             $key = array_search($mainRegionId, array_column($getRegionNameVal, 'category_id'));
    //             if ($key === FALSE) {
    //                 $mainRegionName = '';
    //             } else {
    //                 $mainRegionName = $getRegionNameVal[$key]['category_name'];
    //             }
    //         }
    //         // $empId = $employee->empID;
    //         $data['unit'] = $unitName;
    //         $data['region'] = $mainRegionName;
    //         $data['territory'] = $territoryName;
    //         $data['headquarter'] = $headquarterName;
    //         $data['work_region'] = $employee->category_name;
    //         $data['employee_name'] = $employee->emp_name;
    //         $data['doj'] = $employee->date_of_joining;
    //         $data['status'] = $employee->deleteFlag == 0 ? 'Active' : 'Deactive';
    //         $data['edp_no'] = $employee->EDP_code;
    //         $data['ic_count'] = $employee->ic ? $employee->ic : 0;
    //         $data['sd_count'] = $employee->sd ? $employee->sd : 0;
    //         $data['sdv_count'] = $employee->sdv ? $employee->sdv : 0;
    //         $data['fd_count'] = $employee->fd ? $employee->fd : 0;
    //         $data['fm_count'] = $employee->fm ? $employee->fm : 0;
    //         $data['av_count'] = $employee->av ? $employee->av : 0;
    //         $data['revisit_count'] = $employee->revisit ? $employee->revisit : 0;
    //         $data['dealer_count'] = $employee->dealer_profile ? $employee->dealer_profile : 0;
    //         $data['liquidation_count'] = $employee->liquidation ? $employee->liquidation : 0;
    //         array_push($reportArray, $data);
    //     }
    //     return response()->json([
    //         'code' => 200,
    //         'report_data' => $reportArray,
    //         'result' => $getAllCountData,
    //     ]);
    // }
    
    // farmer 360
    public function getFarmerDetailsReport(Request $request)
    {
        $regionID = $request->regionIndex;
        
        if ($request->timeFrameValue != "0") {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
        }else{
            $fromDate = date('Y-m-d',strtotime('-10 days'));
            $toDate = date('Y-m-d');
        }
        if ($regionID != '' && $fromDate != '' && $toDate != '') {
            $getAllRegionIDs = $this->getRegionId($request->regionIndex);
            $result = DB::table('tbl_farmer as tf')
                ->select('tf.farmerId', 'tf.farmerLatLong','tf.farmerPincode','tf.farmerType', 'tf.farmerBuyingPattern', 'tf.whatsUpFlag', 'tf.verifiedFlag',
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName'), 
                    'tf.farmerMobile','tf.farmerAltNumber', 'tf.farmerLocation', 'tf.farmerPincode', 'tf.farmerRegion', 'tf.farmerWaterDependency', 'tf.farmerSourceOfIrrigation', 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress'), 
                     DB::raw('CONVERT(CAST(CONVERT(tf.farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity'), 
                    'tf.farmerLandAcerage', 'tf.farmerCrop', 'tf.farmerAcreage', 'tf.farmerRegDate', 'tf.activity_time', 
                    'te.emp_name',
                    'tcc.category_name',
                    'te.emp_name',  DB::raw('COALESCE(x.cnt, 0) AS testimonial'))
                ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                ->leftJoin(DB::raw('(SELECT customerId, COUNT(*) cnt FROM tbl_testimonial GROUP BY customerId) x'), 'tf.farmerId', '=', 'x.customerId')
                ->whereIn('tf.farmerRegion', explode(',', $getAllRegionIDs))
                ->whereBetween('tf.farmerRegDate', [$fromDate, $toDate])
                ->orderBy('tf.farmerId', 'asc');
            // print_r($result);
            if ($request->keyword) {
                $result = $result->orWhere(function ($query) use ($request) {
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerRegDate', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerMobile', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.farmerAddress', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tcc.category_name', 'like', '%' . $request->keyword . '%');
                });
            }
            // dd($result->toSql()); // View the generated SQL query
            // dd($result->get()->toArray()); // View the results
            // Calculate the total count before paginating
            $totalCount = $result->count();
            if ($request->paginate == "true") {
                $result = $result->simplePaginate();
            } else {
                $result = $result->get()->toArray();
            }

            // print_r($result);
            return response()->json([
                'code' => 200,
                'total_records' => $totalCount, // Include the total count in the response
                'report_data' => $result,
            ]);
        } else {
            return response()->json([
                'code' => 200,
                'total_records' => 0,
                'report_data' => 'Please Select Date and Region',
            ]);
        }
    }
    public function gettestimonial(Request $request)
    {
        try {
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $empID = $request->empID;
            $query = DB::table('tbl_testimonial as ts');

            if ($request->keyword) {
                $query->orWhere(function ($query) use ($request) {
                    $query->orWhere('tct.customer_type_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tc.cropName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tp.productName', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('te.emp_name', 'like', '%' . $request->keyword . '%');
                    $query->orWhere('tf.testRemark', 'like', '%' . $request->keyword . '%');
                });
            }

            $query
                ->leftJoin('tbl_category as tce', 'tce.category_id', '=', 'ts.regionId')
                ->leftJoin('tbl_crop as tc', 'tc.cropId', '=', 'ts.cropId')
                ->leftJoin('tbl_employee as te', 'te.id', '=', 'ts.empId')
                ->leftJoin('tbl_activity_product as tp', 'tp.pid', '=', 'ts.productId')
                ->leftJoin('tbl_customer_type as tct', 'tct.customer_type_id', '=', 'ts.testCustTypeId')
                ->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'ts.customerId')
                ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'ts.customerId');
            if ($request->testCustTypeId == 1) {
                $result = $result->leftJoin('tbl_farmer as tf', 'tf.farmerId', '=', 'ts.customerId');
            } elseif ($request->testCustTypeId == 2 || $request->testCustTypeId == 3) {
                $result = $result->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'ts.customerId');
            }

            $query->orderBy('ts.testId', 'desc')->where('te.deleteFlag', 0);

            if ($request->timeFrameValue != "0") {
                $query->whereBetween('ts.testDate', [$fromDate, $toDate]);
            }

            if ($request->empID) {
                $query->where('ts.empId', $request->empID);
            }

            if ($request->paginate == "true") {
                $result = $query
                    ->select(
                        'ts.*',
                        'tct.customer_type_name',
                        'tc.cropName',
                        'tp.productName',
                        'te.emp_name',
                        'tf.farmerName',
                        'ta.agencyShopName',
                        DB::raw("(CASE
                            WHEN ts.testCustTypeId = 1 THEN tf.farmerName
                            WHEN ts.testCustTypeId IN (2, 3) THEN ta.agencyShopName
                            ELSE ''
                            END) as customerName")
                    )
                    ->paginate();

                return response()->json([
                    'code' => 200,
                    'data' => $result->items(),
                    'pagination' => [
                        'current_page' => $result->currentPage(),
                        'last_page' => $result->lastPage(),
                        'per_page' => $result->perPage(),
                        'total' => $result->total(),
                    ],
                    'from' => $result->firstItem(), // Add "from" value
                    'to' => $result->lastItem(), // Add "to" value
                ]);
            } else {
                $result = $query
                    ->select(
                        'ts.*',
                        'tct.customer_type_name',

                        'tc.cropName',
                        'tp.productName',
                        'te.emp_name',
                        'tf.farmerName',
                        'ta.agencyShopName',
                        DB::raw("(CASE
                            WHEN ts.testCustTypeId = 1 THEN tf.farmerName
                            WHEN ts.testCustTypeId IN (2, 3) THEN ta.agencyShopName
                            ELSE ''
                            END) as customerName")
                    )
                    ->get()
                    ->toArray();

                return response()->json([
                    'code' => 200,
                    'data' => $result,
                ]);
            }
        } catch (\Exception $e) {
            dd($e->getMessage());
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while saving data",
            ]);
        }
    }
    public function getdashboarddetails(Request $request)
    {
        $date = date('Y-m-d', strtotime($request->date));
        $regionID = $request->regionID;
        // $regionID = 1;
        $getAllRegionIDs = $this->getRegionId($regionID);
        $getAllEmpIDs = $this->getEmployeeId($regionID);
        
        // employee daystart data
        $getEmployeeDetails = DB::table('tbl_employee as e')
            ->leftJoin('tbl_designation as td', 'e.empDesignation', 'td.designationId')
            ->join('tbl_daystart as tds', function ($join) use ($date) {
                $join->on('e.id', '=', 'tds.uid')->where('tds.date', '=', $date);
            })
            ->whereIn('e.region',explode(',',$getAllRegionIDs))
            ->select('e.emp_name', 'tds.stime', 'tds.date', 'tds.status')
            ->get()
            ->toArray();
        // dd($getAllEmpIDs);
        // order data
        $orderdata = DB::table('tbl_ordernew as tp');

        $orderdata = $orderdata
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
            ->whereDate('tp.date', $date)
            ->whereIn('tp.emp_id', $getAllEmpIDs)
            ->select('tp.oid', 'tp.created_at', DB::raw('CONVERT(CAST(CONVERT(tc.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName'), 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval')
            ->get();
        $array = DB::table('tbl_product')
            ->get()
            ->pluck('productName', 'pid')
            ->toArray();
        
        // payment data
        $paymentdata = DB::table('tbl_payment as tp')
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where('tp.approvstatus', 0)
            ->whereIN('tp.region',explode(',',$getAllRegionIDs))
            ->whereDate('tp.created_at', $date) // Use whereDate to match the date only
            ->select(
                'tp.id',
                DB::raw('CONVERT(CAST(CONVERT(ta.agencyName USING latin1) AS BINARY) USING utf8mb4) as agencyName'),
                //'ta.agencyShopName',
                DB::raw('CONVERT(CAST(CONVERT(ta.agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName'),
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.check_numb',
                'tp.chequeDate',
                'tp.UTRNo'
            )
            ->get();

        $locationdata = DB::table('tbl_daystart as tds')
            ->where('tds.date', $date)
            ->select('tds.date', 'tds.sgps')
            ->get()
            ->toArray();

        $formattedDate = date('Y-m-d', strtotime($date));

        // Fetch the activity details using the formatted date
        $activityCounts = DB::table('tbl_activity_count_current_year')
            ->select(
                DB::raw('COALESCE(SUM(ic), 0) as total_ic'),
                DB::raw('COALESCE(SUM(sd), 0) as total_sd'),
                DB::raw('COALESCE(SUM(sdv), 0) as total_sdv'),
                DB::raw('COALESCE(SUM(fd), 0) as total_fd'),
                DB::raw('COALESCE(SUM(fm), 0) as total_fm'),
                DB::raw('COALESCE(SUM(av), 0) as total_av'),
                DB::raw('COALESCE(SUM(liquidation), 0) as total_liquidation'),
                DB::raw('COALESCE(SUM(revisit), 0) as total_revisit')
            )
            ->where('activityDate', $formattedDate)
            ->whereIn('regionId', explode(',', $getAllRegionIDs))
            ->first();

        return response()->json([
            'code' => 200,
            'report_data' => $getEmployeeDetails,
            'order_data' => $orderdata,
            'allProduct' => $array,
            'payment_data' => $paymentdata,
            'locationdata' => $locationdata,
            'activity_counts' => $activityCounts,
        ]);
    }
    public function getgraphicaldashdetails(Request $request)
    {
        $date = date('Y-m-d', strtotime($request->date));

        $fromDate = $request->input('fromDate');
        $toDate = $request->input('toDate');

        $attendancedata = DB::table('tbl_daystart')
            ->join('tbl_employee', 'tbl_daystart.uid', '=', 'tbl_employee.id')
            ->select('tbl_daystart.date', DB::raw('COUNT(*) AS present_count'))
            ->where('tbl_employee.deleteFlag', 0) // Filter active employees only
            ->when($fromDate, function ($query) use ($fromDate) {
                return $query->where('tbl_daystart.date', '>=', $fromDate);
            })
            ->when($toDate, function ($query) use ($toDate) {
                return $query->where('tbl_daystart.date', '<=', $toDate);
            })
            ->groupBy('tbl_daystart.date')
            ->orderBy('tbl_daystart.date')
            ->get();

        $distributorCount = DB::table('tbl_agency as ta')
            ->where('ta.agencyType', 1)
            ->where('ta.isDeleted', 0)
            ->whereBetween('ta.created_at', [$fromDate, $toDate])
            ->count();
        $dealerCount = DB::table('tbl_agency as ta')
            ->where('ta.agencyType', 2)
            ->where('ta.isDeleted', 0)
            ->whereBetween('ta.created_at', [$fromDate, $toDate])
            ->count();

        $orderdata = DB::table('tbl_ordernew as tp')
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.emp_id')
            ->leftJoin('tbl_agency as tc', 'tc.agencyId', '=', 'tp.did')
            ->leftJoin('tbl_product as to', 'to.pid', '=', 'tp.pid')
            ->where('tp.approval', 0)
            ->whereDate('tp.created_at', $date)
            ->select('tp.oid', 'tp.created_at', 'tc.agencyShopName', 'te.emp_name', 'tp.pid', 'tp.qty', 'tp.rate', 'tp.approval')
            ->get();

        $paymentdata = DB::table('tbl_payment as tp')
            ->leftJoin('tbl_employee as te', 'te.id', '=', 'tp.collected_by')
            ->leftJoin('tbl_agency as ta', 'ta.agencyId', '=', 'tp.dealerName')
            ->leftJoin('tbl_category as tc', 'tc.category_id', '=', 'tp.region')
            ->where('tp.approvstatus', 0)
            ->whereDate('tp.created_at', $date)
            ->select(
                'tp.id',
                'ta.agencyName',
                'ta.agencyShopName',
                'tp.region',
                'te.emp_name',
                'tp.amountPaid',
                'tp.paymentMethod',
                'tp.payId',
                'tp.created_at',
                'tp.remark',
                'tp.payimg',
                'tp.paymentAgainst',
                'tp.bankName',
                'tp.branchName',
                'tp.depositedIn',
                'tp.check_numb',
                'tp.chequeDate',
                'tp.UTRNo'
            )
            ->get();

        // Fetch the activity details for the given date range
        $activityCounts = DB::table('tbl_activity_count_current_year')
            ->select(
                DB::raw('SUM(ic) as total_ic'),
                DB::raw('SUM(sd) as total_sd'),
                DB::raw('SUM(sdv) as total_sdv'),
                DB::raw('SUM(fd) as total_fd'),
                DB::raw('SUM(fm) as total_fm'),
                DB::raw('SUM(av) as total_av'),
                DB::raw('SUM(liquidation) as total_liquidation'),
                DB::raw('SUM(revisit) as total_revisit')
            )
            ->whereDate('activityDate', '>=', $fromDate)
            ->whereDate('activityDate', '<=', $toDate)
            ->first();

        return response()->json([
            'code' => 200,
            'report_data' => $attendancedata,
            'order_data' => $orderdata,
            'payment_data' => $paymentdata,
            'activity_counts' => $activityCounts,
            'Distributor_counts' => $distributorCount,
            'Dealer_counts' => $dealerCount,
        ]);
    }
    public function getDayStartDetails(Request $request)
    {
        $usedwhich = $request->header('usedwhich');
        $regionIndex = $request->region;
        $categoryIDWithParent = $regionIndex . ',' . $this->getRegionId($regionIndex);
        $getAllRegionIDs = rtrim($categoryIDWithParent, ',');

        $getEmpData = Employee::whereIn('region', explode(',', $getAllRegionIDs))
            ->where('deleteFlag', 0)
            ->get()
            ->pluck('id')
            ->toArray();
        $empUidArray = [];
        foreach ($getEmpData as $value) {
            array_push($empUidArray, $usedwhich . '-emp' . $value);
        }

        // $getTrackDetails = DB::table('tbl_track')->whereIn('eid', $empUidArray)->where('date', $request->date)->get()->pluck('lltb')->toArray();
        $getTrackDetails = DB::table('tbl_track')
            ->whereIn('eid', $empUidArray)
            ->where('date', '2023-07-29')
            ->get()
            ->pluck('lltb')
            ->toArray();
        $positionArray = [];
        foreach ($getTrackDetails as $value) {
            $getLatLng = explode('/', explode('#', $value)[0]);
            $data['lat'] = floatval($getLatLng[0]);
            $data['lng'] = floatval($getLatLng[1]);
            array_push($positionArray, $data);
        }

        return response()->json([
            'code' => 200,
            'position' => $positionArray,
        ]);
    }
    
    public function getHierarchicalData()
    {
        $rootCategory = Category::whereNull('parent_id')->with('children.employees')->get();

        // Transform the categories and employees into the desired JSON structure.
        $data = $this->transformToHierarchy($rootCategory);

        return response()->json($data);
    }

    protected function transformToHierarchy($categories)
    {
        return $categories->map(function ($category) {
            $data = [
                'text' => $category->name,
                'nodes' => $this->transformToHierarchy($category->children),
            ];

            if ($category->employees->count() > 0) {
                $data['nodes'][] = $category->employees->map(function ($employee) {
                    return [
                        'text' => $employee->name,
                        'nodes' => [],
                    ];
                });
            }

            return $data;
        });
    }
    
    
   public function getCategoryAndEmployeeData()
{
        $rootCategories = Category::where('parent_category_id', 0)->get();

        $tree = [];

        foreach ($rootCategories as $rootCategory) {
            $tree[] = $this->buildTree($rootCategory);
        }

        return response()->json($tree);
    }

    private function buildTree($category)
    {
        $tree = [
            'text' => $category->category_name,
            'nodes' => [],
        ];

        $children = $category->children;

        foreach ($children as $child) {
            $tree['nodes'][] = $this->buildTree($child);
        }

        $employees = Employee::where('region', $category->category_name)->get();

        foreach ($employees as $employee) {
            $tree['nodes'][] = [
                'text' => $employee->emp_name,
                'nodes' => [],
            ];
        }

        return $tree;
    }
    
  
    public function getRegionNodeArray(Request $request)
    {
        $categories = Category::all();
        $data = $this->getNodeData($request->regionID);

        return response()->json(array_values($data));
    }

    private function getNodeData($parentCategoryId)
    {
        $output = [];
        $categories = Category::where('parent_category_id', $parentCategoryId)
            ->where('category_name', '<>', '')
            ->orderBy('category_id')
            ->get();

        foreach ($categories as $category) {
            $subArray = [];
            $empName = '';

            if ($category->empId) {
                $employee = $this->getEmployeeById($category->empId);
                $empName = $employee ? $employee->emp_name : '';
            }

            $type = $this->getRegionType($category->region_type);

            $subArray['text'] = $category->category_name . ' - (' . $type . ') - ' . $empName;
            $subArray['nodes'] = array_values($this->getNodeData($category->category_id));

            $output[] = $subArray;
        }

        return $output;
    }

    private function getEmployeeById($empId)
    {
        // Assuming you have an Employee model
        return Employee::find($empId);
    }

    private function getRegionType($regionType)
    {
        switch ($regionType) {
            case 1:
                return 'Unit';
            case 2:
                return 'Region';
            case 3:
                return 'Territory';
            case 4:
                return 'Headquarter';
            case 5:
                return 'Market';
            default:
                return ($regionType == 1) ? '' : 'Other';
        }
    }
    
    // gps log report
    public function getGPSLogReportData(Request $request)
    {
        
        $curDate = $request->curDate;
        $empID = $request->empID;
        
        // SELECT *
        // FROM (
        //     SELECT *,
        //           LAG(gps_status) OVER (ORDER BY gps_time) AS prev_status
        //     FROM tbl_gps_log_status
        //     WHERE empId = 103 AND date = '2024-03-05'
        // ) AS subquery
        // WHERE (gps_status <> prev_status OR prev_status IS NULL)
        // ORDER BY date, empId, gps_time;
                
        
       $subquery = DB::table('tbl_gps_log_status')
    ->select('*')
    ->selectRaw('LAG(gps_status) OVER (ORDER BY gps_time) AS prev_status')
    ->where('empId', $empID)
    ->whereDate('date', $curDate);

$result = DB::table(DB::raw("({$subquery->toSql()}) as subquery"))
    ->mergeBindings($subquery)
    ->select('*')
    ->whereRaw('(gps_status <> prev_status OR prev_status IS NULL)')
    ->orderBy('date')
    ->orderBy('empId')
    ->orderBy('gps_time');
    
        $totalCount = $result->count();

        if ($request->paginate == "true") {
            $result = $result->paginate(15);
        } else {
            $result = $result->get();
        }
        
        
        $gpsdata = [];
        if(count($result) > 0){
            foreach ($result as $row) {
                $gpsdata[] = [
                    'id' => $row->id,
                    'empId' => $row->empId,
                    'date' => $row->date,
                    'gps_time' => $row->gps_time,
                    'status' => ($row->gps_status == 1) ? 'ON' : 'OFF'
                ];
            }
            $paginate = $result->toArray();
            unset($paginate['data']);
            return response()->json(['code' => 201, 'message' => 'Data fetch successfully','data' => $gpsdata,'pagination' => $paginate]);
        }else{
            return response()->json(['code' => 201, 'message' => 'Data not available','data' => $gpsdata]);
        }
        
        return response()->json([
            'code' => 200,
            'report_data' => $result,
            'total_records' => $totalCount,
        ]);
    
    }
    
    //===================== todays work ===========================
    
    public function getTodaysActivityReport(Request $request)
    {
        try {
            
            $regionIndex = $request->regionIndex;
            $curDate = $request->curDate;
            
            $getDetails = DB::table('tbl_track as t1')
                            ->leftJoin('tbl_employee as t2','t1.eid','t2.eid')
                            ->select('activityGeotag','t1.id','t1.eid','t2.emp_name')
                            ->where('date', $curDate);
            
            if($request->regionIndex){
                $getAllRegionIDs = $this->getRegionId($regionIndex);
                $getDetails = $getDetails->whereIn('t2.region',explode(',', $getAllRegionIDs));
            }
            
            $getDetails =  $getDetails->get()->toArray();
            // dd($getDetails);
            $activity_name = [];
            foreach($getDetails as $empActDetail){
                $activityGeotagForMarkerPosition = $empActDetail->activityGeotag ? explode('#', $empActDetail->activityGeotag) : [];
                     //get activity name
                $empName = $empActDetail->emp_name;
                foreach ($activityGeotagForMarkerPosition as $position) {
                    $indVal = explode('/', $position);
                    $activityName = '';
                    $purpose = '';
                    $villageName = '';
                    $image = '';
                    if(floatval($indVal[3]) == '0' || floatval($indVal[3]) == 20 || floatval($indVal[3]) == 10 || floatval($indVal[3]) == 11){}else{
                        if(floatval($indVal[3]) == 1){
                            $ic = DB::table('tbl_farmer as t1')->leftJoin('tbl_category as t2','t2.category_id','t1.farmerRegion')->where('farmerId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),'category_name',DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"))->first();
                            $activityName = ($ic) ?  $ic->farmerName : '';
                            $purpose = 'IC';
                            $villageName = ($ic) ?  $ic->farmerCity : '';
                            $image = '';
            
                        }else if(floatval($indVal[3]) == 2){
                            $sd = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'SD_photo')->first();
                            $activityName = ($sd) ?  $sd->farmerName : '';
                            $purpose = 'SD';
                            $villageName = ($sd) ?  $sd->farmerCity : '';
                            $image = ($sd) ?  $sd->SD_photo : '';
                            
                        }else if(floatval($indVal[3]) == 3){
                            $sdv = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'SDV_photo')->first();
                            $activityName = ($sdv) ?  $sdv->farmerName : '';
                            $purpose = 'SDV';
                            $villageName = ($sdv) ?  $sdv->farmerCity : '';
                            $image = ($sdv) ?  $sdv->SDV_photo : '';
            
                        }else if(floatval($indVal[3]) == 4){
                            $fd = DB::table('tbl_farmactivityFD as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('fafdId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'fd_image')->first();
                            $activityName = ($fd) ?  $fd->farmerName : '';
                            $purpose = 'FD';
                            $villageName = ($fd) ?  $fd->farmerCity : '';
                            $image = ($fd) ?  $fd->fd_image : '';
            
                        }else if(floatval($indVal[3]) == 5){
                            $fm = DB::table('tbl_farmermeeting as t1')->where('fmId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(villageNameID USING latin1) AS BINARY) USING utf8mb4) as villageNameID"),'fmPhoto')->first();
                            $activityName = ($fm) ?  $fm->villageNameID : '';
                            $purpose = 'FM';
                            $villageName = '';
                            $image = ($fm) ? $fm->fmPhoto : '';
            
                        }else if(floatval($indVal[3]) == 6){
                            $av = DB::table('tbl_agencyvisit as t1')->leftJoin('tbl_agency as t2','t1.agencyId','t2.agencyId')->where('visitId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),DB::raw("CONVERT(CAST(CONVERT(agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"),'aVisitPhoto_key')->first();
                            $activityName = ($av) ?  $av->agencyShopName : '';
                            $purpose = 'AV';
                            $villageName = ($av) ?  $av->agencyCity : '';
                            $image = ($av) ?  $av->aVisitPhoto_key : '';
            
                        }else if(floatval($indVal[3]) == 7){
                            $newAg = DB::table('tbl_agency as t1')->where('agencyId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),DB::raw("CONVERT(CAST(CONVERT(agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"))->first();
                            $activityName = ($newAg) ?  $newAg->agencyShopName : '';
                            $purpose = 'New agency';
                            $villageName = ($newAg) ?  $newAg->agencyCity : '';
                            $image = '';
            
                        }else if(floatval($indVal[3]) == 8){
                            $order = DB::table('tbl_ordernew as t1')->leftJoin('tbl_agency as t2','t1.did','t2.agencyId')->where('oid',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),DB::raw("CONVERT(CAST(CONVERT(agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"),'img')->first();
                            $activityName = ($order) ?  $newAg->agencyShopName : '';
                            $purpose = 'Order';
                            $villageName = ($order) ?  $order->agencyCity : '';
                            $image = ($order) ?  $order->img : '';
            
                        }else if(floatval($indVal[3]) == 9){
                            $payment = DB::table('tbl_payment as t1')->leftJoin('tbl_agency as t2','t1.dealerName','t2.agencyId')->where('id',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(agencyShopName USING latin1) AS BINARY) USING utf8mb4) as agencyShopName"),DB::raw("CONVERT(CAST(CONVERT(agencyCity USING latin1) AS BINARY) USING utf8mb4) as agencyCity"),'payimg')->first();
                            $activityName = ($payment) ?  $payment->agencyShopName : '';
                            $purpose = 'Payment';
                            $villageName = ($payment) ?  $payment->agencyCity : '';
                            $image = ($payment) ?  $payment->payimg : '';
            
                        }else if(floatval($indVal[3]) == 12){
                            $revisit = DB::table('tbl_revisit as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('rid',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'photo')->first();
                            $activityName = ($revisit) ?  $revisit->farmerName : '';
                            $purpose = 'Revisit';
                            $villageName = ($revisit) ?  $revisit->farmerCity : '';
                            $image = ($revisit) ?  $revisit->photo : '';
            
                        }
                        $object = [
                                    'activityType' => floatval($indVal[3]),
                                    'Purpose' => $purpose,
                                    'activity_name' => $activityName,
                                    'villageName' => $villageName,
                                    'empName' => $empName,
                                    'activity_time' => $indVal[2],
                                    'image' => $image
                                ];
                        
                        array_push($activity_name, $object);
                    }
                }
           
            }
            
            //sort the array as per activitytime
            $activity_name = collect($activity_name)->sortByDesc(function ($item) {
                    return strtotime($item['activity_time']);
                })->values()->all();
            $totalCount = count($activity_name);
            // Applying pagination to the $activity_name array
            
            if($request->paginate == "true"){
                $page = $request->has('page') ? $request->page : 1;
                $perPage = 15; 
                $offset = ($page - 1) * $perPage;
                
                $paginatedData = array_slice($activity_name, $offset, $perPage);
                // dd($paginatedData);
                $paginator = new LengthAwarePaginator($paginatedData, $totalCount, $perPage, $page, [
                    'path' => $request->url(),
                    'query' => $request->query(),
                ]);
                $paginate = [
                            'total' => $totalCount,
                            'per_page' => $perPage,
                            'current_page' => $page,
                            'from' => $paginator->firstItem(),
                            'to' => $paginator->lastItem(),
                            'last_page' => $paginator->lastPage(),
                            'next_page_url' => $paginator->nextPageUrl(),
                            'prev_page_url' => $paginator->previousPageUrl(),
                        ];
            }else{
                $paginate = null;
                $paginatedData = $activity_name;
            }
            return response()->json([
                'code' => 200,
                'data' => $paginatedData,
                'total_records' => $totalCount, // Include total record count in the response
                'paginate' => $paginate, // Include total record count in the response
            ]);
               
           
            
        } catch (\Exception $e) {
            // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
            return response()->json([
                'code' => 500,
                'message' => "Something went wrong while fetching data"
            ]);
        }
    }
    
    //farmer activity
    public function getFarmerActivityReport(Request $request)
    {
        //try {
            
            $regionIndex = $request->regionIndex;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            
            $getDetails = DB::table('tbl_track as t1')
                            ->leftJoin('tbl_employee as t2','t1.eid','t2.eid')
                            ->select('activityGeotag','t1.id','t1.eid','t2.emp_name','t1.date');
            
            if($request->empID){
                $getDetails = $getDetails->where('t2.id',$request->empID);
            }else{
                $getAllRegionIDs = $this->getRegionId($regionIndex);
                $getDetails = $getDetails->whereIn('t2.region',explode(',', $getAllRegionIDs));
            }
            
            if ($request->timeFrameValue != "0") {
                $dateRange = [$fromDate, $toDate]; // Use the same date for both start and end of the range
                $getDetails = $getDetails->whereBetween('date', $dateRange);
            }
        
            $getDetails =  $getDetails->get()->toArray();
            // dd($getDetails);
            $activity_name = [];
            foreach($getDetails as $empActDetail){
                $activityGeotagForMarkerPosition = $empActDetail->activityGeotag ? explode('#', $empActDetail->activityGeotag) : [];
                     //get activity name
                $empName = $empActDetail->emp_name;
                $date = $empActDetail->date;
                foreach ($activityGeotagForMarkerPosition as $position) {
                    $indVal = explode('/', $position);
                    $activityName = '';
                    $purpose = '';
                    $villageName = '';
                    $farmerMobile = '';
                    $farmerAddress = '';
                    $image = '';
                    if(floatval($indVal[3]) == '1' || floatval($indVal[3]) == 2 || floatval($indVal[3]) == 3 || floatval($indVal[3]) == 4|| floatval($indVal[3]) == 5 || floatval($indVal[3]) == 12){
                        if(floatval($indVal[3]) == 1){
                            $ic = DB::table('tbl_farmer as t1')->leftJoin('tbl_category as t2','t2.category_id','t1.farmerRegion')->where('farmerId',floatval($indVal[4]))->select( DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'category_name','farmerMobile',DB::raw("CONVERT(CAST(CONVERT(farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"))->first();
                            $activityName = ($ic) ?  $ic->farmerName : '';
                            $purpose = 'IC';
                            $villageName = ($ic) ?  $ic->farmerCity : '';
                            $farmerMobile = ($ic) ?  $ic->farmerMobile : '';
                            $farmerAddress = ($ic) ?  $ic->farmerAddress : '';
                            $image = '';
            
                        }else if(floatval($indVal[3]) == 2){
                            $sd = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select('SD_photo',DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'farmerMobile',DB::raw("CONVERT(CAST(CONVERT(farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"))->first();
                            $activityName = ($sd) ?  $sd->farmerName : '';
                            $purpose = 'SD';
                            $villageName = ($sd) ?  $sd->farmerCity : '';
                            $farmerMobile = ($sd) ?  $sd->farmerMobile : '';
                            $farmerAddress = ($sd) ?  $sd->farmerAddress : '';
                            $image = ($sd) ?  $sd->SD_photo : '';
                            
                        }else if(floatval($indVal[3]) == 3){
                            $sdv = DB::table('tbl_farmactivity as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('faId',floatval($indVal[4]))->select('SDV_photo',DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'farmerMobile',DB::raw("CONVERT(CAST(CONVERT(farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"))->first();
                            $activityName = ($sdv) ?  $sdv->farmerName : '';
                            $purpose = 'SDV';
                            $villageName = ($sdv) ?  $sdv->farmerCity : '';
                            $farmerMobile = ($sdv) ?  $sdv->farmerMobile : '';
                            $farmerAddress = ($sdv) ?  $sdv->farmerAddress : '';
                            $image = ($sdv) ?  $sdv->SDV_photo : '';
            
                        }else if(floatval($indVal[3]) == 4){
                            $fd = DB::table('tbl_farmactivityFD as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('fafdId',floatval($indVal[4]))->select('fd_image',DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'farmerMobile',DB::raw("CONVERT(CAST(CONVERT(farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"))->first();
                            $activityName = ($fd) ?  $fd->farmerName : '';
                            $purpose = 'FD';
                            $villageName = ($fd) ?  $fd->farmerCity : '';
                            $farmerMobile = ($fd) ?  $fd->farmerMobile : '';
                            $farmerAddress = ($fd) ?  $fd->farmerAddress : '';
                            $image = ($fd) ?  $fd->fd_image : '';
            
                        }else if(floatval($indVal[3]) == 5){
                            $fm = DB::table('tbl_farmermeeting as t1')->where('fmId',floatval($indVal[4]))->select(DB::raw("CONVERT(CAST(CONVERT(villageNameID USING latin1) AS BINARY) USING utf8mb4) as villageNameID"),'fmPhoto')->first();
                            $activityName = ($fm) ?  $fm->villageNameID : '';
                            $purpose = 'FM';
                            $villageName = '';
                            $farmerMobile = '';
                            $farmerAddress = '';
                            $image = ($fm) ? $fm->fmPhoto : '';
            
                        }else if(floatval($indVal[3]) == 12){
                            $revisit = DB::table('tbl_revisit as t1')->leftJoin('tbl_farmer as t2','t1.farmerId','t2.farmerId')->where('rid',floatval($indVal[4]))->select('photo',DB::raw("CONVERT(CAST(CONVERT(farmerName USING latin1) AS BINARY) USING utf8mb4) as farmerName"),DB::raw("CONVERT(CAST(CONVERT(farmerCity USING latin1) AS BINARY) USING utf8mb4) as farmerCity"),'farmerMobile',DB::raw("CONVERT(CAST(CONVERT(farmerAddress USING latin1) AS BINARY) USING utf8mb4) as farmerAddress"))->first();
                            $activityName = ($revisit) ?  $revisit->farmerName : '';
                            $purpose = 'Revisit';
                            $villageName = ($revisit) ?  $revisit->farmerCity : '';
                            $farmerMobile = ($revisit) ?  $revisit->farmerMobile : '';
                            $farmerAddress = ($revisit) ?  $revisit->farmerAddress : '';
                            $image = ($revisit) ?  $revisit->photo : '';
            
                        }
                        
                        
                        $object = [
                                    'activityType' => floatval($indVal[3]),
                                    'Purpose' => $purpose,
                                    'activity_name' => $activityName,
                                    'villageName' => $villageName,
                                    'farmerAddress' => $farmerAddress,
                                    'farmerMobile' => $farmerMobile,
                                    'empName' => $empName,
                                    'activity_time' => $indVal[2],
                                    'date' => $date,
                                    'image' => $image
                                ];
                        
                        array_push($activity_name, $object);
                    }
                }
           
            }
            
            //sort the array as per activitytime
            $activity_name = collect($activity_name)->sortByDesc(function ($item) {
                    return strtotime($item['activity_time']);
                })->values()->all();
            $totalCount = count($activity_name);
            // Applying pagination to the $activity_name array
            
            if($request->paginate == "true"){
                $page = $request->has('page') ? $request->page : 1;
                $perPage = 15; 
                $offset = ($page - 1) * $perPage;
                
                $paginatedData = array_slice($activity_name, $offset, $perPage);
                // dd($paginatedData);
                $paginator = new LengthAwarePaginator($paginatedData, $totalCount, $perPage, $page, [
                    'path' => $request->url(),
                    'query' => $request->query(),
                ]);
                $paginate = [
                            'total' => $totalCount,
                            'from' => $paginator->firstItem(),
                            'to' => $paginator->lastItem(),
                            'per_page' => $perPage,
                            'current_page' => $page,
                            'last_page' => $paginator->lastPage(),
                            'next_page_url' => $paginator->nextPageUrl(),
                            'prev_page_url' => $paginator->previousPageUrl(),
                        ];
            }else{
                $paginate = null;
                $paginatedData = $activity_name;
            }
            return response()->json([
                'code' => 200,
                'data' => $paginatedData,
                'total_records' => $totalCount, // Include total record count in the response
                'paginate' => $paginate, // Include total record count in the response
            ]);
               
           
            
        // } catch (\Exception $e) {
        //     // dd($e->getMessage()); // Uncomment this line for debugging purposes if needed
        //     return response()->json([
        //         'code' => 500,
        //         'message' => "Something went wrong while fetching data"
        //     ]);
        // }
    }
}



